pkgname =  "rustbindgen"
pkgver  = "0.72.1" 
source  = f"https://github.com/rust-lang/rust-bindgen/archive/refs/tags/v{pkgver}/rust-bindgen-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/rust-bindgen-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["rustc", "llvm"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/rust-bindgen-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && cargo build --release",
    f"cd {builddir} && rm -rf /usr/bin/bindgen && install -v -m755 target/release/bindgen /usr/bin",
    f"cd {builddir} && bindgen --generate-shell-completions bash > /usr/share/bash-completion/completions/bindgen || true && bindgen --generate-shell-completions zsh > /usr/share/zsh/site-functions/_bindgen || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
