pkgname =  "rustc"
pkgver  = "1.89.0" 
source  = f"https://static.rust-lang.org/dist/rustc-{pkgver}-src.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}-src"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cmake", "curl", "libssh2", "llvm"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}-src.tar.xz",

    # 64-bit build
    f"cd {builddir} && rm -rf /opt/rustc* && mkdir -pv /opt/rustc-{pkgver} || true && rm -rf /opt/rustc && ln -svfn rustc-{pkgver} /opt/rustc || true",
    f"""cd {builddir} && cat << EOF > bootstrap.toml
# See bootstrap.toml.example for more possible options,
# and see src/bootstrap/defaults/bootstrap.dist.toml for a few options
# automatically set when building from a release tarball
# (unfortunately, we have to override many of them).

# Tell x.py the editors have reviewed the content of this file
# and updated it to follow the major changes of the building system,
# so x.py will not warn us to do such a review.
change-id = 142379

[llvm]
# When using system llvm prefer shared libraries
link-shared = true

# If building the shipped LLVM source, only enable the x86 target
# instead of all the targets supported by LLVM.
targets = "X86"

[build]
description = "for BLFS r12.4-113"

# Omit docs to save time and space (default is to build them).
docs = false

# Do not query new versions of dependencies online.
locked-deps = true

# Specify which extended tools (those from the default install).
tools = ["cargo", "clippy", "rustdoc", "rustfmt"]

[install]
prefix = "/opt/rustc-{pkgver}"
docdir = "share/doc/rustc-{pkgver}"

[rust]
channel = "stable"

# Enable the same optimizations as the official upstream build.
lto = "thin"
codegen-units = 1

# Don't build lld which does not belong to this package and seems not
# so useful for BLFS.  Even if it turns out to be really useful we'd build
# it as a part of the LLVM package instead.
lld = false

# Don't build llvm-bitcode-linker which is only useful for the NVPTX
# backend that we don't enable.
llvm-bitcode-linker = false

[target.x86_64-unknown-linux-gnu]
llvm-config = "/usr/bin/llvm-config"

[target.i686-unknown-linux-gnu]
llvm-config = "/usr/bin/llvm-config"
EOF""",
    f"cd {builddir} && export LIBSSH2_SYS_USE_PKG_CONFIG=1 && export LIBSQLITE3_SYS_USE_PKG_CONFIG=1 && ./x.py build",
    f"cd {builddir} && export LIBSSH2_SYS_USE_PKG_CONFIG=1 && export LIBSQLITE3_SYS_USE_PKG_CONFIG=1 && ./x.py install",
    f"cd {builddir} && export LIBSSH2_SYS_USE_PKG_CONFIG=1 && export LIBSQLITE3_SYS_USE_PKG_CONFIG=1 && rm -fv /opt/rustc-{pkgver}/share/doc/rustc-{pkgver}/*.old",
    f"cd {builddir} && export LIBSSH2_SYS_USE_PKG_CONFIG=1 && export LIBSQLITE3_SYS_USE_PKG_CONFIG=1 && install -vm644 README.md /opt/rustc-{pkgver}/share/doc/rustc-{pkgver}",
    f"cd {builddir} && export LIBSSH2_SYS_USE_PKG_CONFIG=1 && export LIBSQLITE3_SYS_USE_PKG_CONFIG=1 && install -vdm755 /usr/share/zsh/site-functions || true",
    f"cd {builddir} && export LIBSSH2_SYS_USE_PKG_CONFIG=1 && export LIBSQLITE3_SYS_USE_PKG_CONFIG=1 && ln -sfv /opt/rustc/share/zsh/site-functions/_cargo /usr/share/zsh/site-functions || true",
    f"cd {builddir} && export LIBSSH2_SYS_USE_PKG_CONFIG=1 && export LIBSQLITE3_SYS_USE_PKG_CONFIG=1 && mv -v /etc/bash_completion.d/cargo /usr/share/bash-completion/completions || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
