pkgname =  "sbc"
pkgver  = "2.1" 
source  = f"https://www.kernel.org/pub/linux/bluetooth/sbc-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libsndfile"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr --disable-static --disable-tester",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
