pkgname =  "sdbus-cpp"
pkgver  = "2.1.0" 
source  = f"https://github.com/Kistler-Group/sdbus-cpp/archive/v{pkgver}/sdbus-cpp-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cmake", "dbus"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && cmake -D CMAKE_INSTALL_PREFIX=/usr -D CMAKE_BUILD_TYPE=Release -D CMAKE_SKIP_INSTALL_RPATH=ON -G Ninja ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install && mv -v /usr/share/doc/sdbus-c++{{,-2.1.0}} || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
