pkgname =  "sddm"
pkgver  = "0.21.0" 
source  = f"https://github.com/sddm/sddm/archive/v{pkgver}/sddm-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cmake", "extra-cmake-modules", "qt6", "Linux-PAM"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && cmake -D CMAKE_INSTALL_PREFIX=/usr -D CMAKE_BUILD_TYPE=Release -D CMAKE_POLICY_VERSION_MINIMUM=3.5 -D ENABLE_JOURNALD=OFF -D NO_SYSTEMD=ON -D RUNTIME_DIR=/run/sddm -D USE_ELOGIND=ON -D BUILD_MAN_PAGES=ON -D BUILD_WITH_QT6=ON -D DATA_INSTALL_DIR=/usr/share/sddm -D DBUS_CONFIG_FILENAME=sddm_org.freedesktop.DisplayManager.conf ..",
    f"cd {builddir}/build && make -j$(nproc)",
    f"cd {builddir}/build && make install",
    f"""cd {builddir} && cat > /etc/pam.d/sddm << "EOF"
# Begin /etc/pam.d/sddm

auth     requisite      pam_nologin.so
auth     required         pam_env.so

auth     required       pam_succeed_if.so uid >= 1000 quiet
auth     include        system-auth

account  include        system-account
password include        system-password

session  required       pam_limits.so
session  include        system-session

# End /etc/pam.d/sddm
EOF

cat > /etc/pam.d/sddm-autologin << "EOF"
# Begin /etc/pam.d/sddm-autologin

auth     requisite      pam_nologin.so
auth     required       pam_env.so

auth     required       pam_succeed_if.so uid >= 1000 quiet
auth     required       pam_permit.so

account      include        system-account

password required       pam_deny.so

session  required       pam_limits.so
session  include        system-session

# End /etc/pam.d/sddm-autologin
EOF

cat > /etc/pam.d/sddm-greeter << "EOF"
# Beg   in /etc/pam.d/sddm-greeter

auth     required       pam_env.so
auth     required       pam_permit.so

account  required       pam_permit.so
password required       pam_deny.so
session  required       pam_unix.so
-session optional       pam_systemd.so

# End /etc/pam.d/sddm-greeter
EOF""",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
