pkgname =  "sdl2"
pkgver  = "2.32.10" 
source  = f"https://www.libsdl.org/release/SDL2-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/SDL2-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libxkbcommon", "wayland-protocols", "xorg-libs"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/SDL2-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install && rm -v /usr/lib/libSDL2*.a || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
