pkgname =  "shadow-pam"
pkgver  = "4.18.0" 
source  = f"https://github.com/shadow-maint/shadow/releases/download/{pkgver}/shadow-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/shadow-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir -p /tmp/fempkg/build {fembuilddir} && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/shadow-{pkgver}.tar.xz",

    # 64-bit build
    f"""cd {builddir} && \
    sed -i 's/groups$(EXEEXT) //' src/Makefile.in && \
    find man -name Makefile.in -exec sed -i 's/groups\\.1 / /' {{}} \\; && \
    find man -name Makefile.in -exec sed -i 's/getspnam\\.3 / /' {{}} \\; && \
    find man -name Makefile.in -exec sed -i 's/passwd\\.5 / /' {{}} \\; && \
    sed -e 's@#ENCRYPT_METHOD DES@ENCRYPT_METHOD YESCRYPT@' \
        -e 's@/var/spool/mail@/var/mail@' \
        -e '/PATH=/{{s@/sbin:@@;s@/bin:@@}}' -i etc/login.defs && \
    ./configure --sysconfdir=/etc --disable-static --without-libbsd --with-{{b,yes}}cryp""",

    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make exec_prefix=/usr pamddir= install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
