pkgname = "spirv-llvm-translator"
pkgver  = "20.1.5"
source  = f"https://github.com/KhronosGroup/SPIRV-LLVM-Translator/archive/v{pkgver}/SPIRV-LLVM-Translator-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/SPIRV-LLVM-Translator-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libxml2", "llvm", "spirv-tools"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && "
    f"tar -xvf /var/lib/fempkg/pkgs/SPIRV-LLVM-Translator-{pkgver}.tar.gz",

    # Configure
    f"cd {builddir} && rm -rf build && mkdir build && cd build && cmake "
    f"-D CMAKE_INSTALL_PREFIX=/usr "
    f"-D CMAKE_BUILD_TYPE=Release "
    f"-D BUILD_SHARED_LIBS=ON "
    f"-D CMAKE_SKIP_INSTALL_RPATH=ON "
    f"-DLLVM_DIR=/usr/lib/cmake/llvm "
    f"-DLLVM_EXTERNAL_SPIRV_HEADERS_SOURCE_DIR=/usr "
    f"-G Ninja ..",

    # Build + install
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
