pkgname =  "spirv-tools"
pkgver  = "1.4.321.0" 
source  = f"https://github.com/KhronosGroup/SPIRV-Tools/archive/vulkan-sdk-{pkgver}/SPIRV-Tools-vulkan-sdk-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/SPIRV-Tools-vulkan-sdk-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cmake", "spirv-headers"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/SPIRV-Tools-vulkan-sdk-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && cmake -D CMAKE_INSTALL_PREFIX=/usr -D CMAKE_BUILD_TYPE=Release -D SPIRV_WERROR=OFF -D BUILD_SHARED_LIBS=ON -D SPIRV_TOOLS_BUILD_STATIC=OFF -D SPIRV-Headers_SOURCE_DIR=/usr -G Ninja ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
