pkgname = "sqlite"
pkgver  = "3500400" 
source  = f"http://localhost:8080/{pkgname}-autoconf-{pkgver}.tar.gz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-autoconf-{pkgver}.tar.gz",

    # 64-bit build
    f"cd /sources/{pkgname}-autoconf-{pkgver} && tar -xf ../sqlite-doc-{pkgver}.tar.xz",
    f"cd /sources/{pkgname}-autoconf-{pkgver} && ./configure --prefix=/usr --disable-static --enable-fts{{4,5}} CPPFLAGS=\"-D SQLITE_ENABLE_COLUMN_METADATA=1 -D SQLITE_ENABLE_UNLOCK_NOTIFY=1 -D SQLITE_ENABLE_DBSTAT_VTAB=1 -D SQLITE_SECURE_DELETE=1\"",
    f"cd /sources/{pkgname}-autoconf-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-autoconf-{pkgver} && make install",

    # 32-bit build
    f"cd /sources/{pkgname}-autoconf-{pkgver} && make distclean",
    f"cd /sources/{pkgname}-autoconf-{pkgver} && CC=\"gcc -m32\" CXX=\"g++ -m32\" ./configure --prefix=/usr --libdir=/usr/lib32 --host=i686-pc-linux-gnu --disable-static --enable-fts{{4,5}} CPPFLAGS=\"-D SQLITE_ENABLE_COLUMN_METADATA=1 -D SQLITE_ENABLE_UNLOCK_NOTIFY=1 -D SQLITE_ENABLE_DBSTAT_VTAB=1 -D SQLITE_SECURE_DELETE=1\"",
    f"cd /sources/{pkgname}-autoconf-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-autoconf-{pkgver} && make DESTDIR=$PWD/DESTDIR install",
    f"cd /sources/{pkgname}-autoconf-{pkgver} && cp -Rv DESTDIR/usr/lib32/* /usr/lib32 || true",
    f"cd /sources/{pkgname}-autoconf-{pkgver} && rm -rf DESTDIR || true",

    # Cleanup
    f"rm -rf /sources/{pkgname}-autoconf-{pkgver}"
]
