pkgname =  "ssh"
pkgver  = "10.2" 
source  = f"https://ftp.openbsd.org/pub/OpenBSD/OpenSSH/portable/openssh-{pkgver}p1.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/open{pkgname}-{pkgver}p1"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/open{pkgname}-{pkgver}p1.tar.gz",

    # 64-bit build
    f"""install -v -g sys -m700 -d /var/lib/sshd &&

groupadd -g 50 sshd || true &&
useradd  -c 'sshd PrivSep' \
         -d /var/lib/sshd  \
         -g sshd           \
         -s /bin/false     \
         -u 50 sshd || true""",
    f"cd {builddir} && ./configure --prefix=/usr --sysconfdir=/etc/ssh --with-privsep-path=/var/lib/sshd --with-default-path=/usr/bin --with-superuser-path=/usr/sbin:/usr/bin --with-pid-dir=/run",
    f"cd {builddir} && make -j$(nproc)",
    f"""cd {builddir} && make install && install -v -m755    contrib/ssh-copy-id /usr/bin     &&

install -v -m644    contrib/ssh-copy-id.1 \
                    /usr/share/man/man1              &&
install -v -m755 -d /usr/share/doc/openssh-{pkgver}p1     &&
install -v -m644    INSTALL LICENCE OVERVIEW README* \
                    /usr/share/doc/openssh-{pkgver}p1""",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
