pkgname =  "taglib"
pkgver  = "2.1.1" 
source  = f"https://taglib.org/releases/taglib-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cmake", "utfcpp"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && cmake -D CMAKE_INSTALL_PREFIX=/usr -D CMAKE_BUILD_TYPE=Release -D BUILD_SHARED_LIBS=ON ..",
    f"cd {builddir}/build && make -j$(nproc)",
    f"cd {builddir}/build && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
