# tcl.recipe.py
pkgname = "tcl"
pkgver  = "8.6.16"
version = '.'.join(pkgver.split('.')[:2])
source  = f"http://localhost:8080/{pkgname}{pkgver}-src.tar.gz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}{pkgver}-src.tar.gz",

    # build e patch
    f"cd /sources/{pkgname}{pkgver} && SRCDIR=$(pwd) && cd unix && ./configure --prefix=/usr --mandir=/usr/share/man --disable-rpath",
    f"cd /sources/{pkgname}{pkgver}/unix && make -j$(nproc)",
    f"cd /sources/{pkgname}{pkgver}/unix && sed -e \"s|$SRCDIR/unix|/usr/lib|\" -e \"s|$SRCDIR|/usr/include|\" -i tclConfig.sh",
    f"cd /sources/{pkgname}{pkgver}/unix && sed -e \"s|$SRCDIR/unix/pkgs/tdbc1.1.10|/usr/lib/tdbc1.1.10|\" -e \"s|$SRCDIR/pkgs/tdbc1.1.10/generic|/usr/include|\" -e \"s|$SRCDIR/pkgs/tdbc1.1.10/library|/usr/lib/tcl8.6|\" -e \"s|$SRCDIR/pkgs/tdbc1.1.10|/usr/include|\" -i pkgs/tdbc1.1.10/tdbcConfig.sh",
    f"cd /sources/{pkgname}{pkgver}/unix && sed -e \"s|$SRCDIR/unix/pkgs/itcl4.3.2|/usr/lib/itcl4.3.2|\" -e \"s|$SRCDIR/pkgs/itcl4.3.2/generic|/usr/include|\" -e \"s|$SRCDIR/pkgs/itcl4.3.2|/usr/include|\" -i pkgs/itcl4.3.2/itclConfig.sh",
    f"cd /sources/{pkgname}{pkgver}/unix && unset SRCDIR",
    f"cd /sources/{pkgname}{pkgver}/unix && make install",
    f"cd /sources/{pkgname}{pkgver}/unix && chmod 644 /usr/lib/libtclstub{version}.a",
    f"cd /sources/{pkgname}{pkgver}/unix && chmod -v u+w /usr/lib/libtcl{version}.so",
    f"cd /sources/{pkgname}{pkgver}/unix && make install-private-headers",
    f"cd /sources/{pkgname}{pkgver}/unix && ln -sfv tclsh{version} /usr/bin/tclsh",
    f"cd /sources/{pkgname}{pkgver}/unix && mv /usr/share/man/man3/{{Thread,Tcl_Thread}}.3",
    f"cd /sources/{pkgname}{pkgver} && tar -xf ../tcl{pkgver}-html.tar.gz --strip-components=1",
    f"cd /sources/{pkgname}{pkgver} && mkdir -v -p /usr/share/doc/tcl-{pkgver}",
    f"cd /sources/{pkgname}{pkgver} && cp -v -r  ./html/* /usr/share/doc/tcl-{pkgver}",


    # Cleanup
    f"rm -rf /sources/{pkgname}{pkgver}"
]
