pkgname =  "trove_classifiers"
pkgver  = "2025.8.6.13" 
source  = f"https://files.pythonhosted.org/packages/source/t/trove_classifiers/trove_classifiers-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && sed -i '/calver/s/^/#/;$iversion=\"2025.8.6.13\"' setup.py && pip3 wheel -w dist --no-build-isolation --no-deps --no-cache-dir $PWD",
    f"cd {builddir} && pip3 install --no-index --find-links dist --no-user trove-classifiers",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
