pkgname =  "udev"
pkgver  = "257.8" 
source  = f"http://localhost:8080/systemd-{pkgver}.tar.gz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf systemd-{pkgver}.tar.gz",

    # 64-bit build
    f"cd /sources/systemd-{pkgver} && sed -e 's/GROUP=\"render\"/GROUP=\"video\"/' -e 's/GROUP=\"sgx\", //' -i rules.d/50-udev-default.rules.in",
    f"cd /sources/systemd-{pkgver} && sed -i '/systemd-sysctl/s/^/#/' rules.d/99-systemd.rules.in",
    f"cd /sources/systemd-{pkgver} && sed -e '/NETWORK_DIRS/s/systemd/udev/' -i src/libsystemd/sd-network/network-util.h",
    f"cd /sources/systemd-{pkgver} && mkdir -p build && cd build && meson setup .. --prefix=/usr --buildtype=release -D mode=release -D dev-kvm-mode=0660 -D link-udev-shared=false -D logind=false -D vconsole=false",
    f"cd /sources/systemd-{pkgver}/build && export udev_helpers=$(grep \"'name' :\" ../src/udev/meson.build | awk '{{print $3}}' | tr -d \",'\" | grep -v 'udevadm')",
    f"cd /sources/systemd-{pkgver}/build && export udev_helpers=$(grep \"'name' :\" ../src/udev/meson.build | awk '{{print $3}}' | tr -d \",'\" | grep -v 'udevadm') && ninja udevadm systemd-hwdb $(ninja -n | grep -Eo '(src/(lib)?udev|rules.d|hwdb.d)/[^ ]*') $(realpath libudev.so --relative-to .) $udev_helpers",
    f"cd /sources/systemd-{pkgver}/build && export udev_helpers=$(grep \"'name' :\" ../src/udev/meson.build | awk '{{print $3}}' | tr -d \",'\" | grep -v 'udevadm') &&  install -vm755 -d {{/usr/lib,/etc}}/udev/{{hwdb.d,rules.d,network}} && install -vm755 -d /usr/{{lib,share}}/pkgconfig && install -vm755 udevadm /usr/bin/ && install -vm755 systemd-hwdb /usr/bin/udev-hwdb && ln -svfn ../bin/udevadm /usr/sbin/udevd && cp -av libudev.so{{,*[0-9]}} /usr/lib/ && install -vm644 ../src/libudev/libudev.h /usr/include/ && install -vm644 src/libudev/*.pc /usr/lib/pkgconfig/ && install -vm644 src/udev/*.pc /usr/share/pkgconfig/ && install -vm644 ../src/udev/udev.conf /etc/udev/ && install -vm644 rules.d/* ../rules.d/README /usr/lib/udev/rules.d/ && install -vm644 $(find ../rules.d/*.rules -not -name '*power-switch*') /usr/lib/udev/rules.d/ && install -vm644 hwdb.d/* ../hwdb.d/{{*.hwdb,README}} /usr/lib/udev/hwdb.d/ && install -vm755 $udev_helpers /usr/lib/udev && install -vm644 ../network/99-default.link /usr/lib/udev/network",
    f"cd /sources/systemd-{pkgver}/build && tar -xvf ../../udev-lfs-20230818.tar.xz",
    f"cd /sources/systemd-{pkgver}/build && export udev_helpers=$(grep \"'name' :\" ../src/udev/meson.build | awk '{{print $3}}' | tr -d \",'\" | grep -v 'udevadm') && make -f udev-lfs-20230818/Makefile.lfs install",
    f"cd /sources/systemd-{pkgver}/build && rm -rf *",

    #32-bit build
    f"cd /sources/systemd-{pkgver}/build && PKG_CONFIG_PATH=\"/usr/lib32/pkgconfig\" CC=\"gcc -m32 -march=i686\" CXX=\"g++ -m32 -march=i686\" LANG=en_US.UTF-8 meson setup --prefix=/usr --buildtype=release -Dmode=release -Ddev-kvm-mode=0660 -Dlink-udev-shared=false -Dlogind=false -Dvconsole=false ..",
    f"cd /sources/systemd-{pkgver}/build && ninja $(grep -o -E \"^build (src/libudev|src/udev)[^:]*\" build.ninja | awk '{{ print $2 }}') $(realpath libudev.so --relative-to .)",
    f"cd /sources/systemd-{pkgver}/build && mkdir -pv /usr/lib32/pkgconfig && cp -av libudev.so{{,*[0-9]}} /usr/lib32/ && sed -e \"s;/usr/lib;&32;g\" src/libudev/libudev.pc > /usr/lib32/pkgconfig/libudev.pc",
    f"cd /sources/systemd-{pkgver}/build && udev-hwdb update",


    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
