pkgname =  "udisks"
pkgver  = "2.10.2" 
source  = f"https://github.com/storaged-project/udisks/releases/download/udisks-{pkgver}/udisks-{pkgver}.tar.bz2"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libatasmart", "libblockdev", "libgudev", "polkit", "elogind"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.bz2",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr --sysconfdir=/etc --localstatedir=/var --disable-static --enable-available-modules",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
