pkgname =  "upower"
pkgver  = "1.90.10" 
source  = f"https://gitlab.freedesktop.org/upower/upower/-/archive/v1.90.10/upower-v{pkgver}.tar.bz2"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-v{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libgudev", "libusb"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-v{pkgver}.tar.bz2",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup .. --prefix=/usr --buildtype=release -Dgtk-doc=false -Dman=false -Dsystemdsystemunitdir=no -Dudevrulesdir=/usr/lib/udev/rules.d",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
