pkgname =  "util-linux"
pkgver  = "2.41.1" 
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.xz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd /sources/{pkgname}-{pkgver} && ./configure --bindir=/usr/bin --libdir=/usr/lib --runstatedir=/run --sbindir=/usr/sbin --disable-chfn-chsh --disable-login --disable-nologin --disable-su --disable-setpriv --disable-runuser --disable-pylibmount --disable-liblastlog2 --disable-static --without-python --without-systemd --without-systemdsystemunitdir ADJTIME_PATH=/var/lib/hwclock/adjtime --docdir=/usr/share/doc/util-linux-{pkgver}",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make install",

    # 32-bit build
    f"cd /sources/{pkgname}-{pkgver} && make distclean",
    f"cd /sources/{pkgname}-{pkgver} && mv /usr/bin/ncursesw6-config{{,.tmp}}",
    f"cd /sources/{pkgname}-{pkgver} && CC=\"gcc -m32\" ./configure ADJTIME_PATH=/var/lib/hwclock/adjtime --host=i686-pc-linux-gnu --libdir=/usr/lib32 --runstatedir=/run --sbindir=/usr/sbin --docdir=/usr/share/doc/util-linux-{pkgver} --disable-chfn-chsh --disable-login --disable-nologin --disable-su --disable-setpriv --disable-runuser --disable-pylibmount --disable-liblastlog2 --disable-static --without-python --without-systemd --without-systemdsystemunitdir",
    f"cd /sources/{pkgname}-{pkgver} && mv /usr/bin/ncursesw6-config{{.tmp,}}",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make DESTDIR=$PWD/DESTDIR install",
    f"cd /sources/{pkgname}-{pkgver} && cp -Rv DESTDIR/usr/lib32/* /usr/lib32",
    f"cd /sources/{pkgname}-{pkgver} && rm -rf DESTDIR",

    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
