pkgname =  "util-macros"
pkgver  = "1.20.2" 
source  = f"https://www.x.org/pub/individual/util/util-macros-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = []

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && export XORG_PREFIX=\"/usr\" && export XORG_CONFIG=\"--prefix=$XORG_PREFIX --sysconfdir=/etc --localstatedir=/var --disable-static\" && ./configure $XORG_CONFIG",
    f"cd {builddir} && export XORG_PREFIX=\"/usr\" && export XORG_CONFIG=\"--prefix=$XORG_PREFIX --sysconfdir=/etc --localstatedir=/var --disable-static\" && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
