pkgname =  "v4l-utils"
pkgver  = "1.30.1" 
source  = f"https://www.linuxtv.org/downloads/v4l-utils/v4l-utils-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["alsa-lib", "glu", "libjpeg-turbo"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup .. --prefix=/usr --buildtype=release -D gconv=disabled -D doxygen-doc=disabled",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install && for prog in v4l2gl v4l2grab; do cp -v contrib/test/$prog /usr/bin; done || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
