pkgname =  "vim"
pkgver  = "9.1.1629" 
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.gz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd /sources/{pkgname}-{pkgver} && echo '#define SYS_VIMRC_FILE \"/etc/vimrc\"' >> src/feature.h",
    f"cd /sources/{pkgname}-{pkgver} && ./configure --prefix=/usr",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make install",
    f"cd /sources/{pkgname}-{pkgver} && ln -sv ../vim/vim91/doc /usr/share/doc/vim-9.1.1754 || true",
    f"""cat > /etc/vimrc << "EOF"
" Begin /etc/vimrc

" Ensure defaults are set before customizing settings, not after
source $VIMRUNTIME/defaults.vim
let skip_defaults_vim=1

set nocompatible
set backspace=2
set mouse=
syntax on
if (&term == "xterm") || (&term == "putty")
  set background=dark
endif

" End /etc/vimrc
EOF || true""",

    
    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
