pkgname =  "vulkan-loader"
pkgver  = "1.4.321" 
source  = f"https://github.com/KhronosGroup/Vulkan-Loader/archive/v{pkgver}/Vulkan-Loader-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/Vulkan-Loader-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cmake", "vulkan-headers", "xorg-libs", "wayland"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/Vulkan-Loader-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && cmake -D CMAKE_INSTALL_PREFIX=/usr -D CMAKE_BUILD_TYPE=Release -D CMAKE_SKIP_INSTALL_RPATH=ON -G Ninja ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
