pkgname =  "wireplumber"
pkgver  = "0.5.11" 
source  = f"https://gitlab.freedesktop.org/pipewire/wireplumber/-/archive/{pkgver}/wireplumber-{pkgver}.tar.bz2"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["pipewire", "elogind", "glib", "lua"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.bz2",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup --prefix=/usr --buildtype=release -D system-lua=true ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install && mv -v /usr/share/doc/wireplumber{{,-0.5.11}} || true && rm -vf /etc/xdg/autostart/pulseaudio.desktop && rm -vf /etc/xdg/Xwayland-session.d/00-pulseaudio-x11",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
