pkgname =  "x265"
pkgver  = "4.1" 
source  = f"https://bitbucket.org/multicoreware/x265_git/downloads/x265_{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}_{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["nasm", "cmake"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}_{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && sed -r '/cmake_policy.*(0025|0054)/d' -i source/CMakeLists.txt && mkdir bld && cd bld && cmake -D CMAKE_INSTALL_PREFIX=/usr -D GIT_ARCHETYPE=1 -D CMAKE_POLICY_VERSION_MINIMUM=3.5 -W no-dev ../source",
    f"cd {builddir}/bld && make -j$(nproc)",
    f"cd {builddir}/bld && make install &&  rm -vf /usr/lib/libx265.a",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
