pkgname =  "xcb-util"
pkgver  = "0.4.1" 
source  = f"https://xcb.freedesktop.org/dist/xcb-util-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libxcb"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr --sysconfdir=/etc --localstatedir=/var --disable-static",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
