pkgname =  "xcb-utils"
pkgver  = "1.0.0" 
source  = f"https://xorg.freedesktop.org/archive/individual/lib/hsakmt-1.0.0.tar.bz2"
builddir = f"/tmp/fempkg/build/{pkgname}/hsakmt-1.0.0"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libxcb", "xcb-util"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/hsakmt-1.0.0.tar.bz2",

    # 64-bit build
    f"""cd {builddir} && cat > xcb-utils.md5 << "EOF"
a67bfac2eff696170259ef1f5ce1b611  xcb-util-image-0.4.1.tar.xz
fbdc05f86f72f287ed71b162f1a9725a  xcb-util-keysyms-0.4.1.tar.xz
193b890e2a89a53c31e2ece3afcbd55f  xcb-util-renderutil-0.3.10.tar.xz
581b3a092e3c0c1b4de6416d90b969c3  xcb-util-wm-0.4.2.tar.xz
e85bccd1993992be07232f8b80a814c8  xcb-util-cursor-0.1.6.tar.xz
EOF""",
    f"cd {builddir} && mkdir xcb-utils && cd xcb-utils && grep -v '^#' ../xcb-utils.md5 | awk '{{print $2}}' | wget -i- -c -B https://xorg.freedesktop.org/archive/individual/lib/",
    f"""cd {builddir}/xcb-utils && as_root()
{{
  if   [ $EUID = 0 ];        then $*
  elif [ -x /usr/bin/sudo ]; then sudo $*
  else                            su -c \\\\"$*\\\\"
  fi
}}

export -f as_root && for package in $(grep -v '^#' ../xcb-utils.md5 | awk '{{print $2}}')
do
  packagedir=${{package%.tar.?z*}}
  tar -xf $package
  pushd $packagedir
     ./configure $XORG_CONFIG
     make
     as_root make install
  popd
  rm -rf $packagedir
done""",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
