pkgname =  "xdg-desktop-portal-gtk"
pkgver  = "1.15.3" 
source  = f"https://github.com/flatpak/xdg-desktop-portal-gtk/releases/download/{pkgver}/xdg-desktop-portal-gtk-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["gnome-desktop", "xdg-desktop-portal"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup --prefix=/usr --buildtype=release ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install && rm -rvf /usr/lib/systemd || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
