pkgname =  "xdg-desktop-portal-hyprland"
pkgver  = "1.3.10" 
source  = f"https://github.com/hyprwm/xdg-desktop-portal-hyprland/archive/v{pkgver}/xdg-desktop-portal-hyprland-{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cmake", "hyprland-libs", "hyprland", "xdg-desktop-portal", "wayland-protocols", "wayland", "pipewire", "qt6", "libglvnd", "libdrm", "inih", "sdbus-cpp"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && rm -rf subprojects/sdbus-cpp && mkdir build && cd build && cmake -D CMAKE_INSTALL_PREFIX=/usr -D CMAKE_BUILD_TYPE=Release -G Ninja ..",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install && rm -rvf /usr/lib/systemd || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
