pkgname =  "xdg-desktop-portal"
pkgver  = "1.20.3" 
source  = f"https://github.com/flatpak/xdg-desktop-portal/releases/download/{pkgver}/xdg-desktop-portal-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["fuse", "gdkpixbuf", "json-glib", "pipewire", "dbus", "bubblewrap"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && mkdir build && cd build && meson setup --prefix=/usr --buildtype=release -D tests=disabled .. .",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install && rm -rvf /usr/lib/systemd || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
