pkgname =  "xdg-utils"
pkgver  = "1.2.1" 
source  = f"https://gitlab.freedesktop.org/xdg/xdg-utils/-/archive/v{pkgver}/xdg-utils-v{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-v{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["xmlto"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-v{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && ./configure --prefix=/usr",
    f"cd {builddir} && make -j$(nproc)",
    f"cd {builddir} && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
