pkgname =  "xorg-fonts"
pkgver  = "1.0" 
source  = f"https://www.x.org/archive//individual/font/encodings-1.0.0.tar.bz2"
builddir = f"/tmp/fempkg/build/{pkgname}/encodings-1.0.0"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["xcursor-themes"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/encodings-1.0.0.tar.bz2",

    # 64-bit build
    f"""cd {builddir} && cat > font-7.md5 << "EOF"
a6541d12ceba004c0c1e3df900324642  font-util-1.4.1.tar.xz
a56b1a7f2c14173f71f010225fa131f1  encodings-1.1.0.tar.xz
79f4c023e27d1db1dfd90d041ce89835  font-alias-1.0.5.tar.xz
546d17feab30d4e3abcf332b454f58ed  font-adobe-utopia-type1-1.0.5.tar.xz
063bfa1456c8a68208bf96a33f472bb1  font-bh-ttf-1.0.4.tar.xz
51a17c981275439b85e15430a3d711ee  font-bh-type1-1.0.4.tar.xz
00f64a84b6c9886040241e081347a853  font-ibm-type1-1.0.4.tar.xz
fe972eaf13176fa9aa7e74a12ecc801a  font-misc-ethiopic-1.0.5.tar.xz
3b47fed2c032af3a32aad9acc1d25150  font-xfree86-type1-1.0.5.tar.xz
EOF""",
    f"cd {builddir} && mkdir font && cd font && grep -v '^#' ../font-7.md5 | awk '{{print $2}}' | wget -i- -c -B https://www.x.org/pub/individual/font/",
    f"""cd {builddir}/font && as_root()
{{
  if   [ $EUID = 0 ];        then $*
  elif [ -x /usr/bin/sudo ]; then sudo $*
  else                            su -c \\\\"$*\\\\"
  fi
}}

export -f as_root && for package in $(grep -v '^#' ../font-7.md5 | awk '{{print $2}}')
do
  packagedir=${{package%.tar.?z*}}
  tar -xf $package
  pushd $packagedir
    ./configure $XORG_CONFIG
    make
    as_root make install
  popd
  as_root rm -rf $packagedir
done""",
    f"cd {builddir}/font && install -v -d -m755 /usr/share/fonts || true",
    f"cd {builddir}/font && ln -svfn $XORG_PREFIX/share/fonts/X11/OTF /usr/share/fonts/X11-OTF || true",
    f"cd {builddir}/font && ln -svfn $XORG_PREFIX/share/fonts/X11/TTF /usr/share/fonts/X11-TTF || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
