#so was this
pkgname  = "xorg-input-driver"
pkgver   = "1.5.0"
pkgdesc  = "X.Org Libinput Driver - thin wrapper to use libinput in X"
url      = "https://www.x.org"
source   = f"https://www.x.org/pub/individual/driver/xf86-input-libinput-{pkgver}.tar.xz"
md5      = "f8d0fb6987d843e688d597c2b66ec824"

builddir = f"/tmp/fempkg/build/{pkgname}/xf86-input-libinput-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"

deps = [
    "libinput",     # required
    "xorg-server"   # required
]

build = [
    # Extract
    f"mkdir -p {fembuilddir} && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/xf86-input-libinput-{pkgver}.tar.xz",

    # Configure & build
    f"cd {builddir} && ./configure $XORG_CONFIG && make",

    # Optional tests

    # Install
    f"cd {builddir} && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
