pkgname = "xorg-libs"
pkgver  = "7.0"   # meta version
source  = "https://www.x.org/pub/individual/lib/libX11-1.8.12.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["fontconfig", "libxcb"]

build = [
    # Prepare dirs
    f"mkdir -p {fembuilddir} && cd {fembuilddir}",

    # Download list & all tarballs
    f"cd {fembuilddir} && cat > lib-7.md5 << 'EOF'\n"
    "6ad67d4858814ac24e618b8072900664  xtrans-1.6.0.tar.xz\n"
    "146d770e564812e00f97e0cbdce632b7  libX11-1.8.12.tar.xz\n"
    "e59476db179e48c1fb4487c12d0105d1  libXext-1.3.6.tar.xz\n"
    "c5cc0942ed39c49b8fcd47a427bd4305  libFS-1.0.10.tar.xz\n"
    "d1ffde0a07709654b20bada3f9abdd16  libICE-1.1.2.tar.xz\n"
    "3aeeea05091db1c69e6f768e0950a431  libSM-1.2.6.tar.xz\n"
    "ec09c90a1cfd2c0630321d366a5e7203  libXScrnSaver-1.2.5.tar.xz\n"
    "9acd189c68750b5028cf120e53c68009  libXt-1.3.1.tar.xz\n"
    "85edefb7deaad4590a03fccba517669f  libXmu-1.2.1.tar.xz\n"
    "05b5667aadd476d77e9b5ba1a1de213e  libXpm-3.5.17.tar.xz\n"
    "2a9793533224f92ddad256492265dd82  libXaw-1.0.16.tar.xz\n"
    "baa39ada682dd524491a165bb0dfc708  libXfixes-6.0.2.tar.xz\n"
    "af0a5f0abb5b55f8411cd738cf0e5259  libXcomposite-0.4.6.tar.xz\n"
    "4c54dce455d96e3bdee90823b0869f89  libXrender-0.9.12.tar.xz\n"
    "5ce55e952ec2d84d9817169d5fdb7865  libXcursor-1.2.3.tar.xz\n"
    "ca55d29fa0a8b5c4a89f609a7952ebf8  libXdamage-1.1.6.tar.xz\n"
    "8816cc44d06ebe42e85950b368185826  libfontenc-1.1.8.tar.xz\n"
    "66e03e3405d923dfaf319d6f2b47e3da  libXfont2-2.0.7.tar.xz\n"
    "d378be0fcbd1f689f9a132e0d642bc4b  libXft-2.3.9.tar.xz\n"
    "95a960c1692a83cc551979f7ffe28cf4  libXi-1.8.2.tar.xz\n"
    "228c877558c265d2f63c56a03f7d3f21  libXinerama-1.1.5.tar.xz\n"
    "24e0b72abe16efce9bf10579beaffc27  libXrandr-1.5.4.tar.xz\n"
    "5014282a08b54ec0edfa73c5cf9ae2c1  libXres-1.2.3.tar.xz\n"
    "b62dc44d8e63a67bb10230d54c44dcb7  libXtst-1.2.5.tar.xz\n"
    "8a26503185afcb1bbd2c65e43f775a67  libXv-1.0.13.tar.xz\n"
    "a90a5f01102dc445c7decbbd9ef77608  libXvMC-1.0.14.tar.xz\n"
    "74d1acf93b83abeb0954824da0ec400b  libXxf86dga-1.1.6.tar.xz\n"
    "d3db4b6dc924dc151822f5f7e79ae873  libXxf86vm-1.1.6.tar.xz\n"
    "57c7efbeceedefde006123a77a7bc825  libpciaccess-0.18.1.tar.xz\n"
    "229c877558c265d2f63c56a03f7d3f21  libxkbfile-1.1.3.tar.xz\n"
    "9805be7e18f858bed9938542ed2905dc  libxshmfence-1.3.3.tar.xz\n"
    "53b72ce969745f8d3e41175d6549ce0b  libXpresent-1.0.2.tar.xz\n"
    "EOF",

    f"cd {fembuilddir} && grep -v '^#' lib-7.md5 | awk '{{print $2}}' | wget -i- -c -B https://www.x.org/pub/individual/lib/",

    # Build all
    f"""cd {fembuilddir} && for package in $(grep -v '^#' lib-7.md5 | awk '{{print $2}}'); do
        dir=${{package%.tar.*}}
        echo ">>> Building $dir"
        tar -xf $package
        cd $dir
        export XORG_PREFIX="/usr"
        export XORG_CONFIG="--prefix=$XORG_PREFIX --sysconfdir=/etc --localstatedir=/var --disable-static"
        docdir="--docdir=$XORG_PREFIX/share/doc/$dir"

        case $dir in
          libXfont2-*) ./configure $XORG_CONFIG $docdir --disable-devel-docs ;;
          libXt-*)     ./configure $XORG_CONFIG $docdir --with-appdefaultdir=/etc/X11/app-defaults ;;
          libXpm-*)    ./configure $XORG_CONFIG $docdir --disable-open-zfile ;;
          libpciaccess-*) mkdir build && cd build && meson setup --prefix=$XORG_PREFIX --buildtype=release .. && ninja && ninja install && cd .. && cd .. && rm -rf $dir && continue ;;
          *)           ./configure $XORG_CONFIG $docdir ;;
        esac

        make -j$(nproc)
        make install
        cd ..
        rm -rf $dir
        ldconfig
    done""",

    # Cleanup
    f"rm -rf {fembuilddir}"
]
