# ye uh this recipe was ai generated tho wtv i was lazy, eh
pkgname  = "xorg-server"
pkgver   = "21.1.18"
pkgdesc  = "The core of the X Window system"
url      = "https://www.x.org"
source   = f"https://www.x.org/pub/individual/xserver/{pkgname}-{pkgver}.tar.xz"
md5      = "43225ddc1fd8d7ae7671c25ab6d1f927"

builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"

# Required + Recommended dependencies only
deps = [
    "libxcvt",        # required
    "pixman",         # required
    "xorg-fonts", # required
    "xkeyboard-config", # runtime, required

    # recommended:
    "dbus",
    "elogind",
    "libepoxy",
    "libtirpc",
    #"xorg-input-driver"
]

build = [
    # Extract
    f"mkdir -p {fembuilddir} && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # Optional patch (comment this out if you don't need TearFree backport)
    f"cd {builddir} && test -f ../{pkgname}-{pkgver}-tearfree_backport-1.patch && patch -Np1 -i ../{pkgname}-{pkgver}-tearfree_backport-1.patch || true",

    # Build
    f"""cd {builddir} && mkdir build && cd build && \
    meson setup .. \
        --prefix=/usr \
        --localstatedir=/var \
        -D glamor=true \
        -D systemd_logind=true \
        -D xkb_output_dir=/var/lib/xkb && \
    ninja""",

    # Install
    f"cd {builddir}/build && ninja install",

    # Post-install: dirs required by Xorg
    "mkdir -pv /etc/X11/xorg.conf.d",
    "install -v -d -m1777 /tmp/.{ICE,X11}-unix",
    """bash -c 'cat >> /etc/sysconfig/createfiles << "EOF"
/tmp/.ICE-unix dir 1777 root root
/tmp/.X11-unix dir 1777 root root
EOF'""",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
