pkgname =  "xorgproto"
pkgver  = "2024.1" 
source  = f"https://xorg.freedesktop.org/archive/individual/proto/xorgproto-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["util-macros"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && export XORG_PREFIX=/usr && mkdir build && cd build && meson setup --prefix=$XORG_PREFIX ..",
    f"cd {builddir}/build && export XORG_PREFIX=/usr && ninja",
    f"cd {builddir}/build && export XORG_PREFIX=/usr && ninja install",
    f"cd {builddir}/build && export XORG_PREFIX=/usr && mv -v $XORG_PREFIX/share/doc/xorgproto{{,-{pkgver}}}",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
