pkgname =  "xwayland"
pkgver  = "24.1.8" 
source  = f"https://www.x.org/pub/individual/xserver/xwayland-{pkgver}.tar.xz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["libxcvt", "pixman", "wayland-protocols", "xorg-apps", "xorg-fonts", "libepoxy", "libtirpc", "mesa"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd {builddir} && sed -i '/install_man/,$d' meson.build && mkdir build && cd build && meson setup .. --prefix=$XORG_PREFIX --buildtype=release -D xkb_output_dir=/var/lib/xkb",
    f"cd {builddir}/build && ninja",
    f"cd {builddir}/build && ninja install && install -vm755 hw/vfb/Xvfb /usr/bin || true",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
