# xz.recipe.py
pkgname = "xz"
pkgver  = "5.8.1"
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.xz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.xz",

    # 64-bit build
    f"cd /sources/{pkgname}-{pkgver} && ./configure --prefix=/usr --disable-static --docdir=/usr/share/doc/xz-{pkgver}",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make install",

    # Clean for 32-bit
    f"cd /sources/{pkgname}-{pkgver} && make distclean || true",
    f"cd /sources/{pkgname}-{pkgver} && rm -f config.log",

    # 32-bit build
    f"cd /sources/{pkgname}-{pkgver} && CC=\"gcc -m32\" ./configure --host=i686-pc-linux-gnu --prefix=/usr --libdir=/usr/lib32 --disable-static",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make DESTDIR=$PWD/DESTDIR install",
    f"cp -Rv /sources/{pkgname}-{pkgver}/DESTDIR/usr/lib32/* /usr/lib32/ || true",
    f"rm -rf /sources/{pkgname}-{pkgver}/DESTDIR",

    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
