pkgname =  "yaml-cpp"
pkgver  = "0.8.0" 
source  = f"https://github.com/jbeder/yaml-cpp/archive/refs/tags/{pkgver}.tar.gz"
builddir = f"/tmp/fempkg/build/{pkgname}/{pkgname}-{pkgver}"
fembuilddir = f"/tmp/fempkg/build/{pkgname}"
deps = ["cmake"]

build = [
    # Extract
    f"mkdir /tmp/fempkg/build {fembuilddir} || true && cd {fembuilddir} && tar -xvf /var/lib/fempkg/pkgs/{pkgver}.tar.gz",

    # 64-bit build
    f"cd {builddir} && sed -i '12i #include <cstdint>' src/emitterutils.cpp && mkdir build && cd build && cmake -D CMAKE_INSTALL_PREFIX=/usr -D CMAKE_BUILD_TYPE=Release -DYAML_BUILD_SHARED_LIBS=ON -DCMAKE_POLICY_VERSION_MINIMUM=3.5 ..",
    f"cd {builddir}/build && make -j$(nproc)",
    f"cd {builddir}/build && make install",

    # Cleanup
    f"rm -rf {builddir} {fembuilddir}"
]
