# zlib.recipe.py
pkgname = "zlib"
pkgver  = "1.3.1"
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.gz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd /sources/{pkgname}-{pkgver} && ./configure --prefix=/usr",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make install",
    f"rm -fv /usr/lib/libz.a",

    # Clean for 32-bit
    f"cd /sources/{pkgname}-{pkgver} && make distclean || true",
    f"cd /sources/{pkgname}-{pkgver} && rm -f config.log",

    # 32-bit build
    f"cd /sources/{pkgname}-{pkgver} && "
    "CFLAGS='-m32' CXXFLAGS='-m32' "
    "./configure --prefix=/usr --libdir=/usr/lib32",
    f"cd /sources/{pkgname}-{pkgver} && make -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make DESTDIR=$PWD/DESTDIR install",
    f"cp -Rv /sources/{pkgname}-{pkgver}/DESTDIR/usr/lib32/* /usr/lib32/ || true",
    f"rm -rf /sources/{pkgname}-{pkgver}/DESTDIR",

    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
