# zstd.recipe.py
pkgname = "zstd"
pkgver  = "1.5.7"
source  = f"http://localhost:8080/{pkgname}-{pkgver}.tar.gz"

deps = []

build = [
    # Extract
    f"cd /sources && tar -xvf {pkgname}-{pkgver}.tar.gz",

    # 64-bit build
    f"cd /sources/{pkgname}-{pkgver} && make prefix=/usr -j$(nproc)",
    f"cd /sources/{pkgname}-{pkgver} && make prefix=/usr install",
    f"cd /sources/{pkgname}-{pkgver} && rm -v /usr/lib/libzstd.a",

    # Clean for 32-bit
    f"cd /sources/{pkgname}-{pkgver} && make clean || true",
    f"cd /sources/{pkgname}-{pkgver} && rm -f config.log",

    # 32-bit build
    f"cd /sources/{pkgname}-{pkgver} && CC=\"gcc -m32\" make prefix=/usr",
    f"cd /sources/{pkgname}-{pkgver} && make prefix=/usr DESTDIR=$PWD/DESTDIR install",
    f"cd /sources/{pkgname}-{pkgver} && cp -Rv DESTDIR/usr/lib/* /usr/lib32/",
    f"cd /sources/{pkgname}-{pkgver} && sed -e \"/^libdir/s/lib$/lib32/\" -i /usr/lib32/pkgconfig/libzstd.pc",
    f"cd /sources/{pkgname}-{pkgver} && rm -rf DESTDIR",

    # Cleanup
    f"rm -rf /sources/{pkgname}-{pkgver}"
]
