/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.calib3d;

import java.util.ArrayList;
import java.util.List;
import org.opencv.calib3d.UsacParams;
import org.opencv.core.Mat;
import org.opencv.core.MatOfDouble;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.MatOfPoint3f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.core.TermCriteria;
import org.opencv.utils.Converters;

public class Calib3d {
    public static final int CV_ITERATIVE = 0;
    public static final int CV_EPNP = 1;
    public static final int CV_P3P = 2;
    public static final int CV_DLS = 3;
    public static final int CvLevMarq_DONE = 0;
    public static final int CvLevMarq_STARTED = 1;
    public static final int CvLevMarq_CALC_J = 2;
    public static final int CvLevMarq_CHECK_ERR = 3;
    public static final int LMEDS = 4;
    public static final int RANSAC = 8;
    public static final int RHO = 16;
    public static final int USAC_DEFAULT = 32;
    public static final int USAC_PARALLEL = 33;
    public static final int USAC_FM_8PTS = 34;
    public static final int USAC_FAST = 35;
    public static final int USAC_ACCURATE = 36;
    public static final int USAC_PROSAC = 37;
    public static final int USAC_MAGSAC = 38;
    public static final int CALIB_CB_ADAPTIVE_THRESH = 1;
    public static final int CALIB_CB_NORMALIZE_IMAGE = 2;
    public static final int CALIB_CB_FILTER_QUADS = 4;
    public static final int CALIB_CB_FAST_CHECK = 8;
    public static final int CALIB_CB_EXHAUSTIVE = 16;
    public static final int CALIB_CB_ACCURACY = 32;
    public static final int CALIB_CB_LARGER = 64;
    public static final int CALIB_CB_MARKER = 128;
    public static final int CALIB_CB_PLAIN = 256;
    public static final int CALIB_CB_SYMMETRIC_GRID = 1;
    public static final int CALIB_CB_ASYMMETRIC_GRID = 2;
    public static final int CALIB_CB_CLUSTERING = 4;
    public static final int CALIB_NINTRINSIC = 18;
    public static final int CALIB_USE_INTRINSIC_GUESS = 1;
    public static final int CALIB_FIX_ASPECT_RATIO = 2;
    public static final int CALIB_FIX_PRINCIPAL_POINT = 4;
    public static final int CALIB_ZERO_TANGENT_DIST = 8;
    public static final int CALIB_FIX_FOCAL_LENGTH = 16;
    public static final int CALIB_FIX_K1 = 32;
    public static final int CALIB_FIX_K2 = 64;
    public static final int CALIB_FIX_K3 = 128;
    public static final int CALIB_FIX_K4 = 2048;
    public static final int CALIB_FIX_K5 = 4096;
    public static final int CALIB_FIX_K6 = 8192;
    public static final int CALIB_RATIONAL_MODEL = 16384;
    public static final int CALIB_THIN_PRISM_MODEL = 32768;
    public static final int CALIB_FIX_S1_S2_S3_S4 = 65536;
    public static final int CALIB_TILTED_MODEL = 262144;
    public static final int CALIB_FIX_TAUX_TAUY = 524288;
    public static final int CALIB_USE_QR = 0x100000;
    public static final int CALIB_FIX_TANGENT_DIST = 0x200000;
    public static final int CALIB_FIX_INTRINSIC = 256;
    public static final int CALIB_SAME_FOCAL_LENGTH = 512;
    public static final int CALIB_ZERO_DISPARITY = 1024;
    public static final int CALIB_USE_LU = 131072;
    public static final int CALIB_USE_EXTRINSIC_GUESS = 0x400000;
    public static final int FM_7POINT = 1;
    public static final int FM_8POINT = 2;
    public static final int FM_LMEDS = 4;
    public static final int FM_RANSAC = 8;
    public static final int fisheye_CALIB_USE_INTRINSIC_GUESS = 1;
    public static final int fisheye_CALIB_RECOMPUTE_EXTRINSIC = 2;
    public static final int fisheye_CALIB_CHECK_COND = 4;
    public static final int fisheye_CALIB_FIX_SKEW = 8;
    public static final int fisheye_CALIB_FIX_K1 = 16;
    public static final int fisheye_CALIB_FIX_K2 = 32;
    public static final int fisheye_CALIB_FIX_K3 = 64;
    public static final int fisheye_CALIB_FIX_K4 = 128;
    public static final int fisheye_CALIB_FIX_INTRINSIC = 256;
    public static final int fisheye_CALIB_FIX_PRINCIPAL_POINT = 512;
    public static final int fisheye_CALIB_ZERO_DISPARITY = 1024;
    public static final int fisheye_CALIB_FIX_FOCAL_LENGTH = 2048;
    public static final int CirclesGridFinderParameters_SYMMETRIC_GRID = 0;
    public static final int CirclesGridFinderParameters_ASYMMETRIC_GRID = 1;
    public static final int CALIB_HAND_EYE_TSAI = 0;
    public static final int CALIB_HAND_EYE_PARK = 1;
    public static final int CALIB_HAND_EYE_HORAUD = 2;
    public static final int CALIB_HAND_EYE_ANDREFF = 3;
    public static final int CALIB_HAND_EYE_DANIILIDIS = 4;
    public static final int LOCAL_OPTIM_NULL = 0;
    public static final int LOCAL_OPTIM_INNER_LO = 1;
    public static final int LOCAL_OPTIM_INNER_AND_ITER_LO = 2;
    public static final int LOCAL_OPTIM_GC = 3;
    public static final int LOCAL_OPTIM_SIGMA = 4;
    public static final int NEIGH_FLANN_KNN = 0;
    public static final int NEIGH_GRID = 1;
    public static final int NEIGH_FLANN_RADIUS = 2;
    public static final int NONE_POLISHER = 0;
    public static final int LSQ_POLISHER = 1;
    public static final int MAGSAC = 2;
    public static final int COV_POLISHER = 3;
    public static final int CALIB_ROBOT_WORLD_HAND_EYE_SHAH = 0;
    public static final int CALIB_ROBOT_WORLD_HAND_EYE_LI = 1;
    public static final int SAMPLING_UNIFORM = 0;
    public static final int SAMPLING_PROGRESSIVE_NAPSAC = 1;
    public static final int SAMPLING_NAPSAC = 2;
    public static final int SAMPLING_PROSAC = 3;
    public static final int SCORE_METHOD_RANSAC = 0;
    public static final int SCORE_METHOD_MSAC = 1;
    public static final int SCORE_METHOD_MAGSAC = 2;
    public static final int SCORE_METHOD_LMEDS = 3;
    public static final int SOLVEPNP_ITERATIVE = 0;
    public static final int SOLVEPNP_EPNP = 1;
    public static final int SOLVEPNP_P3P = 2;
    public static final int SOLVEPNP_DLS = 3;
    public static final int SOLVEPNP_UPNP = 4;
    public static final int SOLVEPNP_AP3P = 5;
    public static final int SOLVEPNP_IPPE = 6;
    public static final int SOLVEPNP_IPPE_SQUARE = 7;
    public static final int SOLVEPNP_SQPNP = 8;
    public static final int SOLVEPNP_MAX_COUNT = 9;
    public static final int PROJ_SPHERICAL_ORTHO = 0;
    public static final int PROJ_SPHERICAL_EQRECT = 1;

    public static void Rodrigues(Mat mat, Mat mat2, Mat mat3) {
        Calib3d.Rodrigues_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void Rodrigues(Mat mat, Mat mat2) {
        Calib3d.Rodrigues_1(mat.nativeObj, mat2.nativeObj);
    }

    public static Mat findHomography(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, int n, double d, Mat mat, int n2, double d2) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        return new Mat(Calib3d.findHomography_0(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, n, d, mat.nativeObj, n2, d2));
    }

    public static Mat findHomography(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, int n, double d, Mat mat, int n2) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        return new Mat(Calib3d.findHomography_1(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, n, d, mat.nativeObj, n2));
    }

    public static Mat findHomography(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, int n, double d, Mat mat) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        return new Mat(Calib3d.findHomography_2(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, n, d, mat.nativeObj));
    }

    public static Mat findHomography(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, int n, double d) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        return new Mat(Calib3d.findHomography_3(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, n, d));
    }

    public static Mat findHomography(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, int n) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        return new Mat(Calib3d.findHomography_4(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, n));
    }

    public static Mat findHomography(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        return new Mat(Calib3d.findHomography_5(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj));
    }

    public static Mat findHomography(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, Mat mat, UsacParams usacParams) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        return new Mat(Calib3d.findHomography_6(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, mat.nativeObj, usacParams.getNativeObjAddr()));
    }

    public static double[] RQDecomp3x3(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6) {
        return Calib3d.RQDecomp3x3_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj);
    }

    public static double[] RQDecomp3x3(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5) {
        return Calib3d.RQDecomp3x3_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj);
    }

    public static double[] RQDecomp3x3(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        return Calib3d.RQDecomp3x3_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static double[] RQDecomp3x3(Mat mat, Mat mat2, Mat mat3) {
        return Calib3d.RQDecomp3x3_3(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void decomposeProjectionMatrix(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7, Mat mat8) {
        Calib3d.decomposeProjectionMatrix_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj);
    }

    public static void decomposeProjectionMatrix(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7) {
        Calib3d.decomposeProjectionMatrix_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj);
    }

    public static void decomposeProjectionMatrix(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6) {
        Calib3d.decomposeProjectionMatrix_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj);
    }

    public static void decomposeProjectionMatrix(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5) {
        Calib3d.decomposeProjectionMatrix_3(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj);
    }

    public static void decomposeProjectionMatrix(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Calib3d.decomposeProjectionMatrix_4(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void matMulDeriv(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Calib3d.matMulDeriv_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void composeRT(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, Mat mat10, Mat mat11, Mat mat12, Mat mat13, Mat mat14) {
        Calib3d.composeRT_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, mat12.nativeObj, mat13.nativeObj, mat14.nativeObj);
    }

    public static void composeRT(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, Mat mat10, Mat mat11, Mat mat12, Mat mat13) {
        Calib3d.composeRT_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, mat12.nativeObj, mat13.nativeObj);
    }

    public static void composeRT(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, Mat mat10, Mat mat11, Mat mat12) {
        Calib3d.composeRT_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, mat12.nativeObj);
    }

    public static void composeRT(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, Mat mat10, Mat mat11) {
        Calib3d.composeRT_3(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat10.nativeObj, mat11.nativeObj);
    }

    public static void composeRT(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, Mat mat10) {
        Calib3d.composeRT_4(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat10.nativeObj);
    }

    public static void composeRT(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9) {
        Calib3d.composeRT_5(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj);
    }

    public static void composeRT(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7, Mat mat8) {
        Calib3d.composeRT_6(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj);
    }

    public static void composeRT(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7) {
        Calib3d.composeRT_7(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj);
    }

    public static void composeRT(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6) {
        Calib3d.composeRT_8(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj);
    }

    public static void projectPoints(MatOfPoint3f matOfPoint3f, Mat mat, Mat mat2, Mat mat3, MatOfDouble matOfDouble, MatOfPoint2f matOfPoint2f, Mat mat4, double d) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfDouble matOfDouble2 = matOfDouble;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        Calib3d.projectPoints_0(matOfPoint3f2.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, matOfDouble2.nativeObj, matOfPoint2f2.nativeObj, mat4.nativeObj, d);
    }

    public static void projectPoints(MatOfPoint3f matOfPoint3f, Mat mat, Mat mat2, Mat mat3, MatOfDouble matOfDouble, MatOfPoint2f matOfPoint2f, Mat mat4) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfDouble matOfDouble2 = matOfDouble;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        Calib3d.projectPoints_1(matOfPoint3f2.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, matOfDouble2.nativeObj, matOfPoint2f2.nativeObj, mat4.nativeObj);
    }

    public static void projectPoints(MatOfPoint3f matOfPoint3f, Mat mat, Mat mat2, Mat mat3, MatOfDouble matOfDouble, MatOfPoint2f matOfPoint2f) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfDouble matOfDouble2 = matOfDouble;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        Calib3d.projectPoints_2(matOfPoint3f2.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, matOfDouble2.nativeObj, matOfPoint2f2.nativeObj);
    }

    public static boolean solvePnP(MatOfPoint3f matOfPoint3f, MatOfPoint2f matOfPoint2f, Mat mat, MatOfDouble matOfDouble, Mat mat2, Mat mat3, boolean bl, int n) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        MatOfDouble matOfDouble2 = matOfDouble;
        return Calib3d.solvePnP_0(matOfPoint3f2.nativeObj, matOfPoint2f2.nativeObj, mat.nativeObj, matOfDouble2.nativeObj, mat2.nativeObj, mat3.nativeObj, bl, n);
    }

    public static boolean solvePnP(MatOfPoint3f matOfPoint3f, MatOfPoint2f matOfPoint2f, Mat mat, MatOfDouble matOfDouble, Mat mat2, Mat mat3, boolean bl) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        MatOfDouble matOfDouble2 = matOfDouble;
        return Calib3d.solvePnP_1(matOfPoint3f2.nativeObj, matOfPoint2f2.nativeObj, mat.nativeObj, matOfDouble2.nativeObj, mat2.nativeObj, mat3.nativeObj, bl);
    }

    public static boolean solvePnP(MatOfPoint3f matOfPoint3f, MatOfPoint2f matOfPoint2f, Mat mat, MatOfDouble matOfDouble, Mat mat2, Mat mat3) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        MatOfDouble matOfDouble2 = matOfDouble;
        return Calib3d.solvePnP_2(matOfPoint3f2.nativeObj, matOfPoint2f2.nativeObj, mat.nativeObj, matOfDouble2.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static boolean solvePnPRansac(MatOfPoint3f matOfPoint3f, MatOfPoint2f matOfPoint2f, Mat mat, MatOfDouble matOfDouble, Mat mat2, Mat mat3, boolean bl, int n, float f, double d, Mat mat4, int n2) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        MatOfDouble matOfDouble2 = matOfDouble;
        return Calib3d.solvePnPRansac_0(matOfPoint3f2.nativeObj, matOfPoint2f2.nativeObj, mat.nativeObj, matOfDouble2.nativeObj, mat2.nativeObj, mat3.nativeObj, bl, n, f, d, mat4.nativeObj, n2);
    }

    public static boolean solvePnPRansac(MatOfPoint3f matOfPoint3f, MatOfPoint2f matOfPoint2f, Mat mat, MatOfDouble matOfDouble, Mat mat2, Mat mat3, boolean bl, int n, float f, double d, Mat mat4) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        MatOfDouble matOfDouble2 = matOfDouble;
        return Calib3d.solvePnPRansac_1(matOfPoint3f2.nativeObj, matOfPoint2f2.nativeObj, mat.nativeObj, matOfDouble2.nativeObj, mat2.nativeObj, mat3.nativeObj, bl, n, f, d, mat4.nativeObj);
    }

    public static boolean solvePnPRansac(MatOfPoint3f matOfPoint3f, MatOfPoint2f matOfPoint2f, Mat mat, MatOfDouble matOfDouble, Mat mat2, Mat mat3, boolean bl, int n, float f, double d) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        MatOfDouble matOfDouble2 = matOfDouble;
        return Calib3d.solvePnPRansac_2(matOfPoint3f2.nativeObj, matOfPoint2f2.nativeObj, mat.nativeObj, matOfDouble2.nativeObj, mat2.nativeObj, mat3.nativeObj, bl, n, f, d);
    }

    public static boolean solvePnPRansac(MatOfPoint3f matOfPoint3f, MatOfPoint2f matOfPoint2f, Mat mat, MatOfDouble matOfDouble, Mat mat2, Mat mat3, boolean bl, int n, float f) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        MatOfDouble matOfDouble2 = matOfDouble;
        return Calib3d.solvePnPRansac_3(matOfPoint3f2.nativeObj, matOfPoint2f2.nativeObj, mat.nativeObj, matOfDouble2.nativeObj, mat2.nativeObj, mat3.nativeObj, bl, n, f);
    }

    public static boolean solvePnPRansac(MatOfPoint3f matOfPoint3f, MatOfPoint2f matOfPoint2f, Mat mat, MatOfDouble matOfDouble, Mat mat2, Mat mat3, boolean bl, int n) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        MatOfDouble matOfDouble2 = matOfDouble;
        return Calib3d.solvePnPRansac_4(matOfPoint3f2.nativeObj, matOfPoint2f2.nativeObj, mat.nativeObj, matOfDouble2.nativeObj, mat2.nativeObj, mat3.nativeObj, bl, n);
    }

    public static boolean solvePnPRansac(MatOfPoint3f matOfPoint3f, MatOfPoint2f matOfPoint2f, Mat mat, MatOfDouble matOfDouble, Mat mat2, Mat mat3, boolean bl) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        MatOfDouble matOfDouble2 = matOfDouble;
        return Calib3d.solvePnPRansac_5(matOfPoint3f2.nativeObj, matOfPoint2f2.nativeObj, mat.nativeObj, matOfDouble2.nativeObj, mat2.nativeObj, mat3.nativeObj, bl);
    }

    public static boolean solvePnPRansac(MatOfPoint3f matOfPoint3f, MatOfPoint2f matOfPoint2f, Mat mat, MatOfDouble matOfDouble, Mat mat2, Mat mat3) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        MatOfDouble matOfDouble2 = matOfDouble;
        return Calib3d.solvePnPRansac_6(matOfPoint3f2.nativeObj, matOfPoint2f2.nativeObj, mat.nativeObj, matOfDouble2.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static boolean solvePnPRansac(MatOfPoint3f matOfPoint3f, MatOfPoint2f matOfPoint2f, Mat mat, MatOfDouble matOfDouble, Mat mat2, Mat mat3, Mat mat4, UsacParams usacParams) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        MatOfDouble matOfDouble2 = matOfDouble;
        return Calib3d.solvePnPRansac_7(matOfPoint3f2.nativeObj, matOfPoint2f2.nativeObj, mat.nativeObj, matOfDouble2.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, usacParams.getNativeObjAddr());
    }

    public static boolean solvePnPRansac(MatOfPoint3f matOfPoint3f, MatOfPoint2f matOfPoint2f, Mat mat, MatOfDouble matOfDouble, Mat mat2, Mat mat3, Mat mat4) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        MatOfDouble matOfDouble2 = matOfDouble;
        return Calib3d.solvePnPRansac_8(matOfPoint3f2.nativeObj, matOfPoint2f2.nativeObj, mat.nativeObj, matOfDouble2.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static int solveP3P(Mat mat, Mat mat2, Mat mat3, Mat mat4, List<Mat> list, List<Mat> list2, int n) {
        Mat mat5 = new Mat();
        Mat mat6 = new Mat();
        int n2 = Calib3d.solveP3P_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, n);
        Converters.Mat_to_vector_Mat(mat5, list);
        mat5.release();
        Converters.Mat_to_vector_Mat(mat6, list2);
        mat6.release();
        return n2;
    }

    public static void solvePnPRefineLM(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, TermCriteria termCriteria) {
        Calib3d.solvePnPRefineLM_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
    }

    public static void solvePnPRefineLM(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6) {
        Calib3d.solvePnPRefineLM_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj);
    }

    public static void solvePnPRefineVVS(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, TermCriteria termCriteria, double d) {
        Calib3d.solvePnPRefineVVS_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon, d);
    }

    public static void solvePnPRefineVVS(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, TermCriteria termCriteria) {
        Calib3d.solvePnPRefineVVS_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
    }

    public static void solvePnPRefineVVS(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6) {
        Calib3d.solvePnPRefineVVS_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj);
    }

    public static int solvePnPGeneric(Mat mat, Mat mat2, Mat mat3, Mat mat4, List<Mat> list, List<Mat> list2, boolean bl, int n, Mat mat5, Mat mat6, Mat mat7) {
        Mat mat8 = new Mat();
        Mat mat9 = new Mat();
        int n2 = Calib3d.solvePnPGeneric_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat8.nativeObj, mat9.nativeObj, bl, n, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj);
        Converters.Mat_to_vector_Mat(mat8, list);
        mat8.release();
        Converters.Mat_to_vector_Mat(mat9, list2);
        mat9.release();
        return n2;
    }

    public static int solvePnPGeneric(Mat mat, Mat mat2, Mat mat3, Mat mat4, List<Mat> list, List<Mat> list2, boolean bl, int n, Mat mat5, Mat mat6) {
        Mat mat7 = new Mat();
        Mat mat8 = new Mat();
        int n2 = Calib3d.solvePnPGeneric_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat7.nativeObj, mat8.nativeObj, bl, n, mat5.nativeObj, mat6.nativeObj);
        Converters.Mat_to_vector_Mat(mat7, list);
        mat7.release();
        Converters.Mat_to_vector_Mat(mat8, list2);
        mat8.release();
        return n2;
    }

    public static int solvePnPGeneric(Mat mat, Mat mat2, Mat mat3, Mat mat4, List<Mat> list, List<Mat> list2, boolean bl, int n, Mat mat5) {
        Mat mat6 = new Mat();
        Mat mat7 = new Mat();
        int n2 = Calib3d.solvePnPGeneric_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat6.nativeObj, mat7.nativeObj, bl, n, mat5.nativeObj);
        Converters.Mat_to_vector_Mat(mat6, list);
        mat6.release();
        Converters.Mat_to_vector_Mat(mat7, list2);
        mat7.release();
        return n2;
    }

    public static int solvePnPGeneric(Mat mat, Mat mat2, Mat mat3, Mat mat4, List<Mat> list, List<Mat> list2, boolean bl, int n) {
        Mat mat5 = new Mat();
        Mat mat6 = new Mat();
        int n2 = Calib3d.solvePnPGeneric_3(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, bl, n);
        Converters.Mat_to_vector_Mat(mat5, list);
        mat5.release();
        Converters.Mat_to_vector_Mat(mat6, list2);
        mat6.release();
        return n2;
    }

    public static int solvePnPGeneric(Mat mat, Mat mat2, Mat mat3, Mat mat4, List<Mat> list, List<Mat> list2, boolean bl) {
        Mat mat5 = new Mat();
        Mat mat6 = new Mat();
        int n = Calib3d.solvePnPGeneric_4(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, bl);
        Converters.Mat_to_vector_Mat(mat5, list);
        mat5.release();
        Converters.Mat_to_vector_Mat(mat6, list2);
        mat6.release();
        return n;
    }

    public static int solvePnPGeneric(Mat mat, Mat mat2, Mat mat3, Mat mat4, List<Mat> list, List<Mat> list2) {
        Mat mat5 = new Mat();
        Mat mat6 = new Mat();
        int n = Calib3d.solvePnPGeneric_5(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj);
        Converters.Mat_to_vector_Mat(mat5, list);
        mat5.release();
        Converters.Mat_to_vector_Mat(mat6, list2);
        mat6.release();
        return n;
    }

    public static Mat initCameraMatrix2D(List<MatOfPoint3f> list, List<MatOfPoint2f> list2, Size size, double d) {
        ArrayList<Mat> arrayList = new ArrayList<Mat>(list != null ? list.size() : 0);
        Mat mat = Converters.vector_vector_Point3f_to_Mat(list, arrayList);
        ArrayList<Mat> arrayList2 = new ArrayList<Mat>(list2 != null ? list2.size() : 0);
        Mat mat2 = Converters.vector_vector_Point2f_to_Mat(list2, arrayList2);
        return new Mat(Calib3d.initCameraMatrix2D_0(mat.nativeObj, mat2.nativeObj, size.width, size.height, d));
    }

    public static Mat initCameraMatrix2D(List<MatOfPoint3f> list, List<MatOfPoint2f> list2, Size size) {
        ArrayList<Mat> arrayList = new ArrayList<Mat>(list != null ? list.size() : 0);
        Mat mat = Converters.vector_vector_Point3f_to_Mat(list, arrayList);
        ArrayList<Mat> arrayList2 = new ArrayList<Mat>(list2 != null ? list2.size() : 0);
        Mat mat2 = Converters.vector_vector_Point2f_to_Mat(list2, arrayList2);
        return new Mat(Calib3d.initCameraMatrix2D_1(mat.nativeObj, mat2.nativeObj, size.width, size.height));
    }

    public static boolean findChessboardCorners(Mat mat, Size size, MatOfPoint2f matOfPoint2f, int n) {
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        return Calib3d.findChessboardCorners_0(mat.nativeObj, size.width, size.height, matOfPoint2f2.nativeObj, n);
    }

    public static boolean findChessboardCorners(Mat mat, Size size, MatOfPoint2f matOfPoint2f) {
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        return Calib3d.findChessboardCorners_1(mat.nativeObj, size.width, size.height, matOfPoint2f2.nativeObj);
    }

    public static boolean checkChessboard(Mat mat, Size size) {
        return Calib3d.checkChessboard_0(mat.nativeObj, size.width, size.height);
    }

    public static boolean findChessboardCornersSBWithMeta(Mat mat, Size size, Mat mat2, int n, Mat mat3) {
        return Calib3d.findChessboardCornersSBWithMeta_0(mat.nativeObj, size.width, size.height, mat2.nativeObj, n, mat3.nativeObj);
    }

    public static boolean findChessboardCornersSB(Mat mat, Size size, Mat mat2, int n) {
        return Calib3d.findChessboardCornersSB_0(mat.nativeObj, size.width, size.height, mat2.nativeObj, n);
    }

    public static boolean findChessboardCornersSB(Mat mat, Size size, Mat mat2) {
        return Calib3d.findChessboardCornersSB_1(mat.nativeObj, size.width, size.height, mat2.nativeObj);
    }

    public static Scalar estimateChessboardSharpness(Mat mat, Size size, Mat mat2, float f, boolean bl, Mat mat3) {
        return new Scalar(Calib3d.estimateChessboardSharpness_0(mat.nativeObj, size.width, size.height, mat2.nativeObj, f, bl, mat3.nativeObj));
    }

    public static Scalar estimateChessboardSharpness(Mat mat, Size size, Mat mat2, float f, boolean bl) {
        return new Scalar(Calib3d.estimateChessboardSharpness_1(mat.nativeObj, size.width, size.height, mat2.nativeObj, f, bl));
    }

    public static Scalar estimateChessboardSharpness(Mat mat, Size size, Mat mat2, float f) {
        return new Scalar(Calib3d.estimateChessboardSharpness_2(mat.nativeObj, size.width, size.height, mat2.nativeObj, f));
    }

    public static Scalar estimateChessboardSharpness(Mat mat, Size size, Mat mat2) {
        return new Scalar(Calib3d.estimateChessboardSharpness_3(mat.nativeObj, size.width, size.height, mat2.nativeObj));
    }

    public static boolean find4QuadCornerSubpix(Mat mat, Mat mat2, Size size) {
        return Calib3d.find4QuadCornerSubpix_0(mat.nativeObj, mat2.nativeObj, size.width, size.height);
    }

    public static void drawChessboardCorners(Mat mat, Size size, MatOfPoint2f matOfPoint2f, boolean bl) {
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        Calib3d.drawChessboardCorners_0(mat.nativeObj, size.width, size.height, matOfPoint2f2.nativeObj, bl);
    }

    public static void drawFrameAxes(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, float f, int n) {
        Calib3d.drawFrameAxes_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, f, n);
    }

    public static void drawFrameAxes(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, float f) {
        Calib3d.drawFrameAxes_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, f);
    }

    public static boolean findCirclesGrid(Mat mat, Size size, Mat mat2, int n) {
        return Calib3d.findCirclesGrid_0(mat.nativeObj, size.width, size.height, mat2.nativeObj, n);
    }

    public static boolean findCirclesGrid(Mat mat, Size size, Mat mat2) {
        return Calib3d.findCirclesGrid_2(mat.nativeObj, size.width, size.height, mat2.nativeObj);
    }

    public static double calibrateCameraExtended(List<Mat> list, List<Mat> list2, Size size, Mat mat, Mat mat2, List<Mat> list3, List<Mat> list4, Mat mat3, Mat mat4, Mat mat5, int n, TermCriteria termCriteria) {
        Mat mat6 = Converters.vector_Mat_to_Mat(list);
        Mat mat7 = Converters.vector_Mat_to_Mat(list2);
        Mat mat8 = new Mat();
        Mat mat9 = new Mat();
        double d = Calib3d.calibrateCameraExtended_0(mat6.nativeObj, mat7.nativeObj, size.width, size.height, mat.nativeObj, mat2.nativeObj, mat8.nativeObj, mat9.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, n, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
        Converters.Mat_to_vector_Mat(mat8, list3);
        mat8.release();
        Converters.Mat_to_vector_Mat(mat9, list4);
        mat9.release();
        return d;
    }

    public static double calibrateCameraExtended(List<Mat> list, List<Mat> list2, Size size, Mat mat, Mat mat2, List<Mat> list3, List<Mat> list4, Mat mat3, Mat mat4, Mat mat5, int n) {
        Mat mat6 = Converters.vector_Mat_to_Mat(list);
        Mat mat7 = Converters.vector_Mat_to_Mat(list2);
        Mat mat8 = new Mat();
        Mat mat9 = new Mat();
        double d = Calib3d.calibrateCameraExtended_1(mat6.nativeObj, mat7.nativeObj, size.width, size.height, mat.nativeObj, mat2.nativeObj, mat8.nativeObj, mat9.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, n);
        Converters.Mat_to_vector_Mat(mat8, list3);
        mat8.release();
        Converters.Mat_to_vector_Mat(mat9, list4);
        mat9.release();
        return d;
    }

    public static double calibrateCameraExtended(List<Mat> list, List<Mat> list2, Size size, Mat mat, Mat mat2, List<Mat> list3, List<Mat> list4, Mat mat3, Mat mat4, Mat mat5) {
        Mat mat6 = Converters.vector_Mat_to_Mat(list);
        Mat mat7 = Converters.vector_Mat_to_Mat(list2);
        Mat mat8 = new Mat();
        Mat mat9 = new Mat();
        double d = Calib3d.calibrateCameraExtended_2(mat6.nativeObj, mat7.nativeObj, size.width, size.height, mat.nativeObj, mat2.nativeObj, mat8.nativeObj, mat9.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj);
        Converters.Mat_to_vector_Mat(mat8, list3);
        mat8.release();
        Converters.Mat_to_vector_Mat(mat9, list4);
        mat9.release();
        return d;
    }

    public static double calibrateCamera(List<Mat> list, List<Mat> list2, Size size, Mat mat, Mat mat2, List<Mat> list3, List<Mat> list4, int n, TermCriteria termCriteria) {
        Mat mat3 = Converters.vector_Mat_to_Mat(list);
        Mat mat4 = Converters.vector_Mat_to_Mat(list2);
        Mat mat5 = new Mat();
        Mat mat6 = new Mat();
        double d = Calib3d.calibrateCamera_0(mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat.nativeObj, mat2.nativeObj, mat5.nativeObj, mat6.nativeObj, n, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
        Converters.Mat_to_vector_Mat(mat5, list3);
        mat5.release();
        Converters.Mat_to_vector_Mat(mat6, list4);
        mat6.release();
        return d;
    }

    public static double calibrateCamera(List<Mat> list, List<Mat> list2, Size size, Mat mat, Mat mat2, List<Mat> list3, List<Mat> list4, int n) {
        Mat mat3 = Converters.vector_Mat_to_Mat(list);
        Mat mat4 = Converters.vector_Mat_to_Mat(list2);
        Mat mat5 = new Mat();
        Mat mat6 = new Mat();
        double d = Calib3d.calibrateCamera_1(mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat.nativeObj, mat2.nativeObj, mat5.nativeObj, mat6.nativeObj, n);
        Converters.Mat_to_vector_Mat(mat5, list3);
        mat5.release();
        Converters.Mat_to_vector_Mat(mat6, list4);
        mat6.release();
        return d;
    }

    public static double calibrateCamera(List<Mat> list, List<Mat> list2, Size size, Mat mat, Mat mat2, List<Mat> list3, List<Mat> list4) {
        Mat mat3 = Converters.vector_Mat_to_Mat(list);
        Mat mat4 = Converters.vector_Mat_to_Mat(list2);
        Mat mat5 = new Mat();
        Mat mat6 = new Mat();
        double d = Calib3d.calibrateCamera_2(mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat.nativeObj, mat2.nativeObj, mat5.nativeObj, mat6.nativeObj);
        Converters.Mat_to_vector_Mat(mat5, list3);
        mat5.release();
        Converters.Mat_to_vector_Mat(mat6, list4);
        mat6.release();
        return d;
    }

    public static double calibrateCameraROExtended(List<Mat> list, List<Mat> list2, Size size, int n, Mat mat, Mat mat2, List<Mat> list3, List<Mat> list4, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7, int n2, TermCriteria termCriteria) {
        Mat mat8 = Converters.vector_Mat_to_Mat(list);
        Mat mat9 = Converters.vector_Mat_to_Mat(list2);
        Mat mat10 = new Mat();
        Mat mat11 = new Mat();
        double d = Calib3d.calibrateCameraROExtended_0(mat8.nativeObj, mat9.nativeObj, size.width, size.height, n, mat.nativeObj, mat2.nativeObj, mat10.nativeObj, mat11.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, n2, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
        Converters.Mat_to_vector_Mat(mat10, list3);
        mat10.release();
        Converters.Mat_to_vector_Mat(mat11, list4);
        mat11.release();
        return d;
    }

    public static double calibrateCameraROExtended(List<Mat> list, List<Mat> list2, Size size, int n, Mat mat, Mat mat2, List<Mat> list3, List<Mat> list4, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7, int n2) {
        Mat mat8 = Converters.vector_Mat_to_Mat(list);
        Mat mat9 = Converters.vector_Mat_to_Mat(list2);
        Mat mat10 = new Mat();
        Mat mat11 = new Mat();
        double d = Calib3d.calibrateCameraROExtended_1(mat8.nativeObj, mat9.nativeObj, size.width, size.height, n, mat.nativeObj, mat2.nativeObj, mat10.nativeObj, mat11.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, n2);
        Converters.Mat_to_vector_Mat(mat10, list3);
        mat10.release();
        Converters.Mat_to_vector_Mat(mat11, list4);
        mat11.release();
        return d;
    }

    public static double calibrateCameraROExtended(List<Mat> list, List<Mat> list2, Size size, int n, Mat mat, Mat mat2, List<Mat> list3, List<Mat> list4, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7) {
        Mat mat8 = Converters.vector_Mat_to_Mat(list);
        Mat mat9 = Converters.vector_Mat_to_Mat(list2);
        Mat mat10 = new Mat();
        Mat mat11 = new Mat();
        double d = Calib3d.calibrateCameraROExtended_2(mat8.nativeObj, mat9.nativeObj, size.width, size.height, n, mat.nativeObj, mat2.nativeObj, mat10.nativeObj, mat11.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj);
        Converters.Mat_to_vector_Mat(mat10, list3);
        mat10.release();
        Converters.Mat_to_vector_Mat(mat11, list4);
        mat11.release();
        return d;
    }

    public static double calibrateCameraRO(List<Mat> list, List<Mat> list2, Size size, int n, Mat mat, Mat mat2, List<Mat> list3, List<Mat> list4, Mat mat3, int n2, TermCriteria termCriteria) {
        Mat mat4 = Converters.vector_Mat_to_Mat(list);
        Mat mat5 = Converters.vector_Mat_to_Mat(list2);
        Mat mat6 = new Mat();
        Mat mat7 = new Mat();
        double d = Calib3d.calibrateCameraRO_0(mat4.nativeObj, mat5.nativeObj, size.width, size.height, n, mat.nativeObj, mat2.nativeObj, mat6.nativeObj, mat7.nativeObj, mat3.nativeObj, n2, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
        Converters.Mat_to_vector_Mat(mat6, list3);
        mat6.release();
        Converters.Mat_to_vector_Mat(mat7, list4);
        mat7.release();
        return d;
    }

    public static double calibrateCameraRO(List<Mat> list, List<Mat> list2, Size size, int n, Mat mat, Mat mat2, List<Mat> list3, List<Mat> list4, Mat mat3, int n2) {
        Mat mat4 = Converters.vector_Mat_to_Mat(list);
        Mat mat5 = Converters.vector_Mat_to_Mat(list2);
        Mat mat6 = new Mat();
        Mat mat7 = new Mat();
        double d = Calib3d.calibrateCameraRO_1(mat4.nativeObj, mat5.nativeObj, size.width, size.height, n, mat.nativeObj, mat2.nativeObj, mat6.nativeObj, mat7.nativeObj, mat3.nativeObj, n2);
        Converters.Mat_to_vector_Mat(mat6, list3);
        mat6.release();
        Converters.Mat_to_vector_Mat(mat7, list4);
        mat7.release();
        return d;
    }

    public static double calibrateCameraRO(List<Mat> list, List<Mat> list2, Size size, int n, Mat mat, Mat mat2, List<Mat> list3, List<Mat> list4, Mat mat3) {
        Mat mat4 = Converters.vector_Mat_to_Mat(list);
        Mat mat5 = Converters.vector_Mat_to_Mat(list2);
        Mat mat6 = new Mat();
        Mat mat7 = new Mat();
        double d = Calib3d.calibrateCameraRO_2(mat4.nativeObj, mat5.nativeObj, size.width, size.height, n, mat.nativeObj, mat2.nativeObj, mat6.nativeObj, mat7.nativeObj, mat3.nativeObj);
        Converters.Mat_to_vector_Mat(mat6, list3);
        mat6.release();
        Converters.Mat_to_vector_Mat(mat7, list4);
        mat7.release();
        return d;
    }

    public static void calibrationMatrixValues(Mat mat, Size size, double d, double d2, double[] dArray, double[] dArray2, double[] dArray3, Point point, double[] dArray4) {
        double[] dArray5 = new double[1];
        double[] dArray6 = new double[1];
        double[] dArray7 = new double[1];
        double[] dArray8 = new double[2];
        double[] dArray9 = new double[1];
        Calib3d.calibrationMatrixValues_0(mat.nativeObj, size.width, size.height, d, d2, dArray5, dArray6, dArray7, dArray8, dArray9);
        if (dArray != null) {
            dArray[0] = dArray5[0];
        }
        if (dArray2 != null) {
            dArray2[0] = dArray6[0];
        }
        if (dArray3 != null) {
            dArray3[0] = dArray7[0];
        }
        if (point != null) {
            point.x = dArray8[0];
            point.y = dArray8[1];
        }
        if (dArray4 != null) {
            dArray4[0] = dArray9[0];
        }
    }

    public static double stereoCalibrateExtended(List<Mat> list, List<Mat> list2, List<Mat> list3, Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, List<Mat> list4, List<Mat> list5, Mat mat9, int n, TermCriteria termCriteria) {
        Mat mat10 = Converters.vector_Mat_to_Mat(list);
        Mat mat11 = Converters.vector_Mat_to_Mat(list2);
        Mat mat12 = Converters.vector_Mat_to_Mat(list3);
        Mat mat13 = new Mat();
        Mat mat14 = new Mat();
        double d = Calib3d.stereoCalibrateExtended_0(mat10.nativeObj, mat11.nativeObj, mat12.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat13.nativeObj, mat14.nativeObj, mat9.nativeObj, n, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
        Converters.Mat_to_vector_Mat(mat13, list4);
        mat13.release();
        Converters.Mat_to_vector_Mat(mat14, list5);
        mat14.release();
        return d;
    }

    public static double stereoCalibrateExtended(List<Mat> list, List<Mat> list2, List<Mat> list3, Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, List<Mat> list4, List<Mat> list5, Mat mat9, int n) {
        Mat mat10 = Converters.vector_Mat_to_Mat(list);
        Mat mat11 = Converters.vector_Mat_to_Mat(list2);
        Mat mat12 = Converters.vector_Mat_to_Mat(list3);
        Mat mat13 = new Mat();
        Mat mat14 = new Mat();
        double d = Calib3d.stereoCalibrateExtended_1(mat10.nativeObj, mat11.nativeObj, mat12.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat13.nativeObj, mat14.nativeObj, mat9.nativeObj, n);
        Converters.Mat_to_vector_Mat(mat13, list4);
        mat13.release();
        Converters.Mat_to_vector_Mat(mat14, list5);
        mat14.release();
        return d;
    }

    public static double stereoCalibrateExtended(List<Mat> list, List<Mat> list2, List<Mat> list3, Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, List<Mat> list4, List<Mat> list5, Mat mat9) {
        Mat mat10 = Converters.vector_Mat_to_Mat(list);
        Mat mat11 = Converters.vector_Mat_to_Mat(list2);
        Mat mat12 = Converters.vector_Mat_to_Mat(list3);
        Mat mat13 = new Mat();
        Mat mat14 = new Mat();
        double d = Calib3d.stereoCalibrateExtended_2(mat10.nativeObj, mat11.nativeObj, mat12.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat13.nativeObj, mat14.nativeObj, mat9.nativeObj);
        Converters.Mat_to_vector_Mat(mat13, list4);
        mat13.release();
        Converters.Mat_to_vector_Mat(mat14, list5);
        mat14.release();
        return d;
    }

    public static double stereoCalibrate(List<Mat> list, List<Mat> list2, List<Mat> list3, Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, int n, TermCriteria termCriteria) {
        Mat mat9 = Converters.vector_Mat_to_Mat(list);
        Mat mat10 = Converters.vector_Mat_to_Mat(list2);
        Mat mat11 = Converters.vector_Mat_to_Mat(list3);
        return Calib3d.stereoCalibrate_0(mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, n, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
    }

    public static double stereoCalibrate(List<Mat> list, List<Mat> list2, List<Mat> list3, Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, int n) {
        Mat mat9 = Converters.vector_Mat_to_Mat(list);
        Mat mat10 = Converters.vector_Mat_to_Mat(list2);
        Mat mat11 = Converters.vector_Mat_to_Mat(list3);
        return Calib3d.stereoCalibrate_1(mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, n);
    }

    public static double stereoCalibrate(List<Mat> list, List<Mat> list2, List<Mat> list3, Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8) {
        Mat mat9 = Converters.vector_Mat_to_Mat(list);
        Mat mat10 = Converters.vector_Mat_to_Mat(list2);
        Mat mat11 = Converters.vector_Mat_to_Mat(list3);
        return Calib3d.stereoCalibrate_2(mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj);
    }

    public static double stereoCalibrate(List<Mat> list, List<Mat> list2, List<Mat> list3, Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, int n, TermCriteria termCriteria) {
        Mat mat10 = Converters.vector_Mat_to_Mat(list);
        Mat mat11 = Converters.vector_Mat_to_Mat(list2);
        Mat mat12 = Converters.vector_Mat_to_Mat(list3);
        return Calib3d.stereoCalibrate_3(mat10.nativeObj, mat11.nativeObj, mat12.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, n, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
    }

    public static double stereoCalibrate(List<Mat> list, List<Mat> list2, List<Mat> list3, Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, int n) {
        Mat mat10 = Converters.vector_Mat_to_Mat(list);
        Mat mat11 = Converters.vector_Mat_to_Mat(list2);
        Mat mat12 = Converters.vector_Mat_to_Mat(list3);
        return Calib3d.stereoCalibrate_4(mat10.nativeObj, mat11.nativeObj, mat12.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, n);
    }

    public static double stereoCalibrate(List<Mat> list, List<Mat> list2, List<Mat> list3, Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9) {
        Mat mat10 = Converters.vector_Mat_to_Mat(list);
        Mat mat11 = Converters.vector_Mat_to_Mat(list2);
        Mat mat12 = Converters.vector_Mat_to_Mat(list3);
        return Calib3d.stereoCalibrate_5(mat10.nativeObj, mat11.nativeObj, mat12.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj);
    }

    public static void stereoRectify(Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, Mat mat10, Mat mat11, int n, double d, Size size2, Rect rect, Rect rect2) {
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        Calib3d.stereoRectify_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, n, d, size2.width, size2.height, dArray, dArray2);
        if (rect != null) {
            rect.x = (int)dArray[0];
            rect.y = (int)dArray[1];
            rect.width = (int)dArray[2];
            rect.height = (int)dArray[3];
        }
        if (rect2 != null) {
            rect2.x = (int)dArray2[0];
            rect2.y = (int)dArray2[1];
            rect2.width = (int)dArray2[2];
            rect2.height = (int)dArray2[3];
        }
    }

    public static void stereoRectify(Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, Mat mat10, Mat mat11, int n, double d, Size size2, Rect rect) {
        double[] dArray = new double[4];
        Calib3d.stereoRectify_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, n, d, size2.width, size2.height, dArray);
        if (rect != null) {
            rect.x = (int)dArray[0];
            rect.y = (int)dArray[1];
            rect.width = (int)dArray[2];
            rect.height = (int)dArray[3];
        }
    }

    public static void stereoRectify(Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, Mat mat10, Mat mat11, int n, double d, Size size2) {
        Calib3d.stereoRectify_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, n, d, size2.width, size2.height);
    }

    public static void stereoRectify(Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, Mat mat10, Mat mat11, int n, double d) {
        Calib3d.stereoRectify_3(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, n, d);
    }

    public static void stereoRectify(Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, Mat mat10, Mat mat11, int n) {
        Calib3d.stereoRectify_4(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, n);
    }

    public static void stereoRectify(Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, Mat mat10, Mat mat11) {
        Calib3d.stereoRectify_5(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat10.nativeObj, mat11.nativeObj);
    }

    public static boolean stereoRectifyUncalibrated(Mat mat, Mat mat2, Mat mat3, Size size, Mat mat4, Mat mat5, double d) {
        return Calib3d.stereoRectifyUncalibrated_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, size.width, size.height, mat4.nativeObj, mat5.nativeObj, d);
    }

    public static boolean stereoRectifyUncalibrated(Mat mat, Mat mat2, Mat mat3, Size size, Mat mat4, Mat mat5) {
        return Calib3d.stereoRectifyUncalibrated_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, size.width, size.height, mat4.nativeObj, mat5.nativeObj);
    }

    public static float rectify3Collinear(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, List<Mat> list, List<Mat> list2, Size size, Mat mat7, Mat mat8, Mat mat9, Mat mat10, Mat mat11, Mat mat12, Mat mat13, Mat mat14, Mat mat15, Mat mat16, Mat mat17, double d, Size size2, Rect rect, Rect rect2, int n) {
        Mat mat18 = Converters.vector_Mat_to_Mat(list);
        Mat mat19 = Converters.vector_Mat_to_Mat(list2);
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        float f = Calib3d.rectify3Collinear_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat18.nativeObj, mat19.nativeObj, size.width, size.height, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, mat12.nativeObj, mat13.nativeObj, mat14.nativeObj, mat15.nativeObj, mat16.nativeObj, mat17.nativeObj, d, size2.width, size2.height, dArray, dArray2, n);
        if (rect != null) {
            rect.x = (int)dArray[0];
            rect.y = (int)dArray[1];
            rect.width = (int)dArray[2];
            rect.height = (int)dArray[3];
        }
        if (rect2 != null) {
            rect2.x = (int)dArray2[0];
            rect2.y = (int)dArray2[1];
            rect2.width = (int)dArray2[2];
            rect2.height = (int)dArray2[3];
        }
        return f;
    }

    public static Mat getOptimalNewCameraMatrix(Mat mat, Mat mat2, Size size, double d, Size size2, Rect rect, boolean bl) {
        double[] dArray = new double[4];
        Mat mat3 = new Mat(Calib3d.getOptimalNewCameraMatrix_0(mat.nativeObj, mat2.nativeObj, size.width, size.height, d, size2.width, size2.height, dArray, bl));
        if (rect != null) {
            rect.x = (int)dArray[0];
            rect.y = (int)dArray[1];
            rect.width = (int)dArray[2];
            rect.height = (int)dArray[3];
        }
        return mat3;
    }

    public static Mat getOptimalNewCameraMatrix(Mat mat, Mat mat2, Size size, double d, Size size2, Rect rect) {
        double[] dArray = new double[4];
        Mat mat3 = new Mat(Calib3d.getOptimalNewCameraMatrix_1(mat.nativeObj, mat2.nativeObj, size.width, size.height, d, size2.width, size2.height, dArray));
        if (rect != null) {
            rect.x = (int)dArray[0];
            rect.y = (int)dArray[1];
            rect.width = (int)dArray[2];
            rect.height = (int)dArray[3];
        }
        return mat3;
    }

    public static Mat getOptimalNewCameraMatrix(Mat mat, Mat mat2, Size size, double d, Size size2) {
        return new Mat(Calib3d.getOptimalNewCameraMatrix_2(mat.nativeObj, mat2.nativeObj, size.width, size.height, d, size2.width, size2.height));
    }

    public static Mat getOptimalNewCameraMatrix(Mat mat, Mat mat2, Size size, double d) {
        return new Mat(Calib3d.getOptimalNewCameraMatrix_3(mat.nativeObj, mat2.nativeObj, size.width, size.height, d));
    }

    public static void calibrateHandEye(List<Mat> list, List<Mat> list2, List<Mat> list3, List<Mat> list4, Mat mat, Mat mat2, int n) {
        Mat mat3 = Converters.vector_Mat_to_Mat(list);
        Mat mat4 = Converters.vector_Mat_to_Mat(list2);
        Mat mat5 = Converters.vector_Mat_to_Mat(list3);
        Mat mat6 = Converters.vector_Mat_to_Mat(list4);
        Calib3d.calibrateHandEye_0(mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat.nativeObj, mat2.nativeObj, n);
    }

    public static void calibrateHandEye(List<Mat> list, List<Mat> list2, List<Mat> list3, List<Mat> list4, Mat mat, Mat mat2) {
        Mat mat3 = Converters.vector_Mat_to_Mat(list);
        Mat mat4 = Converters.vector_Mat_to_Mat(list2);
        Mat mat5 = Converters.vector_Mat_to_Mat(list3);
        Mat mat6 = Converters.vector_Mat_to_Mat(list4);
        Calib3d.calibrateHandEye_1(mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat.nativeObj, mat2.nativeObj);
    }

    public static void calibrateRobotWorldHandEye(List<Mat> list, List<Mat> list2, List<Mat> list3, List<Mat> list4, Mat mat, Mat mat2, Mat mat3, Mat mat4, int n) {
        Mat mat5 = Converters.vector_Mat_to_Mat(list);
        Mat mat6 = Converters.vector_Mat_to_Mat(list2);
        Mat mat7 = Converters.vector_Mat_to_Mat(list3);
        Mat mat8 = Converters.vector_Mat_to_Mat(list4);
        Calib3d.calibrateRobotWorldHandEye_0(mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, n);
    }

    public static void calibrateRobotWorldHandEye(List<Mat> list, List<Mat> list2, List<Mat> list3, List<Mat> list4, Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Mat mat5 = Converters.vector_Mat_to_Mat(list);
        Mat mat6 = Converters.vector_Mat_to_Mat(list2);
        Mat mat7 = Converters.vector_Mat_to_Mat(list3);
        Mat mat8 = Converters.vector_Mat_to_Mat(list4);
        Calib3d.calibrateRobotWorldHandEye_1(mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void convertPointsToHomogeneous(Mat mat, Mat mat2) {
        Calib3d.convertPointsToHomogeneous_0(mat.nativeObj, mat2.nativeObj);
    }

    public static void convertPointsFromHomogeneous(Mat mat, Mat mat2) {
        Calib3d.convertPointsFromHomogeneous_0(mat.nativeObj, mat2.nativeObj);
    }

    public static Mat findFundamentalMat(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, int n, double d, double d2, int n2, Mat mat) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        return new Mat(Calib3d.findFundamentalMat_0(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, n, d, d2, n2, mat.nativeObj));
    }

    public static Mat findFundamentalMat(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, int n, double d, double d2, int n2) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        return new Mat(Calib3d.findFundamentalMat_1(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, n, d, d2, n2));
    }

    public static Mat findFundamentalMat(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, int n, double d, double d2, Mat mat) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        return new Mat(Calib3d.findFundamentalMat_2(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, n, d, d2, mat.nativeObj));
    }

    public static Mat findFundamentalMat(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, int n, double d, double d2) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        return new Mat(Calib3d.findFundamentalMat_3(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, n, d, d2));
    }

    public static Mat findFundamentalMat(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, int n, double d) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        return new Mat(Calib3d.findFundamentalMat_4(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, n, d));
    }

    public static Mat findFundamentalMat(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, int n) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        return new Mat(Calib3d.findFundamentalMat_5(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, n));
    }

    public static Mat findFundamentalMat(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        return new Mat(Calib3d.findFundamentalMat_6(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj));
    }

    public static Mat findFundamentalMat(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, Mat mat, UsacParams usacParams) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        return new Mat(Calib3d.findFundamentalMat_7(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, mat.nativeObj, usacParams.getNativeObjAddr()));
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, Mat mat3, int n, double d, double d2, int n2, Mat mat4) {
        return new Mat(Calib3d.findEssentialMat_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, d, d2, n2, mat4.nativeObj));
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, Mat mat3, int n, double d, double d2, int n2) {
        return new Mat(Calib3d.findEssentialMat_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, d, d2, n2));
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, Mat mat3, int n, double d, double d2) {
        return new Mat(Calib3d.findEssentialMat_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, d, d2));
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, Mat mat3, int n, double d) {
        return new Mat(Calib3d.findEssentialMat_3(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, d));
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, Mat mat3, int n) {
        return new Mat(Calib3d.findEssentialMat_4(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n));
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, Mat mat3) {
        return new Mat(Calib3d.findEssentialMat_5(mat.nativeObj, mat2.nativeObj, mat3.nativeObj));
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, double d, Point point, int n, double d2, double d3, int n2, Mat mat3) {
        return new Mat(Calib3d.findEssentialMat_6(mat.nativeObj, mat2.nativeObj, d, point.x, point.y, n, d2, d3, n2, mat3.nativeObj));
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, double d, Point point, int n, double d2, double d3, int n2) {
        return new Mat(Calib3d.findEssentialMat_7(mat.nativeObj, mat2.nativeObj, d, point.x, point.y, n, d2, d3, n2));
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, double d, Point point, int n, double d2, double d3) {
        return new Mat(Calib3d.findEssentialMat_8(mat.nativeObj, mat2.nativeObj, d, point.x, point.y, n, d2, d3));
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, double d, Point point, int n, double d2) {
        return new Mat(Calib3d.findEssentialMat_9(mat.nativeObj, mat2.nativeObj, d, point.x, point.y, n, d2));
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, double d, Point point, int n) {
        return new Mat(Calib3d.findEssentialMat_10(mat.nativeObj, mat2.nativeObj, d, point.x, point.y, n));
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, double d, Point point) {
        return new Mat(Calib3d.findEssentialMat_11(mat.nativeObj, mat2.nativeObj, d, point.x, point.y));
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, double d) {
        return new Mat(Calib3d.findEssentialMat_12(mat.nativeObj, mat2.nativeObj, d));
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2) {
        return new Mat(Calib3d.findEssentialMat_13(mat.nativeObj, mat2.nativeObj));
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, int n, double d, double d2, Mat mat7) {
        return new Mat(Calib3d.findEssentialMat_14(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, n, d, d2, mat7.nativeObj));
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, int n, double d, double d2) {
        return new Mat(Calib3d.findEssentialMat_15(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, n, d, d2));
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, int n, double d) {
        return new Mat(Calib3d.findEssentialMat_16(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, n, d));
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, int n) {
        return new Mat(Calib3d.findEssentialMat_17(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, n));
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6) {
        return new Mat(Calib3d.findEssentialMat_18(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj));
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7, UsacParams usacParams) {
        return new Mat(Calib3d.findEssentialMat_19(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, usacParams.getNativeObjAddr()));
    }

    public static void decomposeEssentialMat(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Calib3d.decomposeEssentialMat_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static int recoverPose(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, int n, double d, double d2, Mat mat10) {
        return Calib3d.recoverPose_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, n, d, d2, mat10.nativeObj);
    }

    public static int recoverPose(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, int n, double d, double d2) {
        return Calib3d.recoverPose_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, n, d, d2);
    }

    public static int recoverPose(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, int n, double d) {
        return Calib3d.recoverPose_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, n, d);
    }

    public static int recoverPose(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, int n) {
        return Calib3d.recoverPose_3(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, n);
    }

    public static int recoverPose(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9) {
        return Calib3d.recoverPose_4(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj);
    }

    public static int recoverPose(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7) {
        return Calib3d.recoverPose_5(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj);
    }

    public static int recoverPose(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6) {
        return Calib3d.recoverPose_6(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj);
    }

    public static int recoverPose(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, double d, Point point, Mat mat6) {
        return Calib3d.recoverPose_7(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, d, point.x, point.y, mat6.nativeObj);
    }

    public static int recoverPose(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, double d, Point point) {
        return Calib3d.recoverPose_8(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, d, point.x, point.y);
    }

    public static int recoverPose(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, double d) {
        return Calib3d.recoverPose_9(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, d);
    }

    public static int recoverPose(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5) {
        return Calib3d.recoverPose_10(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj);
    }

    public static int recoverPose(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, double d, Mat mat7, Mat mat8) {
        return Calib3d.recoverPose_11(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, d, mat7.nativeObj, mat8.nativeObj);
    }

    public static int recoverPose(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, double d, Mat mat7) {
        return Calib3d.recoverPose_12(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, d, mat7.nativeObj);
    }

    public static int recoverPose(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, double d) {
        return Calib3d.recoverPose_13(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, d);
    }

    public static void computeCorrespondEpilines(Mat mat, int n, Mat mat2, Mat mat3) {
        Calib3d.computeCorrespondEpilines_0(mat.nativeObj, n, mat2.nativeObj, mat3.nativeObj);
    }

    public static void triangulatePoints(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5) {
        Calib3d.triangulatePoints_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj);
    }

    public static void correctMatches(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5) {
        Calib3d.correctMatches_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj);
    }

    public static void filterSpeckles(Mat mat, double d, int n, double d2, Mat mat2) {
        Calib3d.filterSpeckles_0(mat.nativeObj, d, n, d2, mat2.nativeObj);
    }

    public static void filterSpeckles(Mat mat, double d, int n, double d2) {
        Calib3d.filterSpeckles_1(mat.nativeObj, d, n, d2);
    }

    public static Rect getValidDisparityROI(Rect rect, Rect rect2, int n, int n2, int n3) {
        return new Rect(Calib3d.getValidDisparityROI_0(rect.x, rect.y, rect.width, rect.height, rect2.x, rect2.y, rect2.width, rect2.height, n, n2, n3));
    }

    public static void validateDisparity(Mat mat, Mat mat2, int n, int n2, int n3) {
        Calib3d.validateDisparity_0(mat.nativeObj, mat2.nativeObj, n, n2, n3);
    }

    public static void validateDisparity(Mat mat, Mat mat2, int n, int n2) {
        Calib3d.validateDisparity_1(mat.nativeObj, mat2.nativeObj, n, n2);
    }

    public static void reprojectImageTo3D(Mat mat, Mat mat2, Mat mat3, boolean bl, int n) {
        Calib3d.reprojectImageTo3D_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, bl, n);
    }

    public static void reprojectImageTo3D(Mat mat, Mat mat2, Mat mat3, boolean bl) {
        Calib3d.reprojectImageTo3D_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, bl);
    }

    public static void reprojectImageTo3D(Mat mat, Mat mat2, Mat mat3) {
        Calib3d.reprojectImageTo3D_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static double sampsonDistance(Mat mat, Mat mat2, Mat mat3) {
        return Calib3d.sampsonDistance_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static int estimateAffine3D(Mat mat, Mat mat2, Mat mat3, Mat mat4, double d, double d2) {
        return Calib3d.estimateAffine3D_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, d, d2);
    }

    public static int estimateAffine3D(Mat mat, Mat mat2, Mat mat3, Mat mat4, double d) {
        return Calib3d.estimateAffine3D_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, d);
    }

    public static int estimateAffine3D(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        return Calib3d.estimateAffine3D_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static Mat estimateAffine3D(Mat mat, Mat mat2, double[] dArray, boolean bl) {
        double[] dArray2 = new double[1];
        Mat mat3 = new Mat(Calib3d.estimateAffine3D_3(mat.nativeObj, mat2.nativeObj, dArray2, bl));
        if (dArray != null) {
            dArray[0] = dArray2[0];
        }
        return mat3;
    }

    public static Mat estimateAffine3D(Mat mat, Mat mat2, double[] dArray) {
        double[] dArray2 = new double[1];
        Mat mat3 = new Mat(Calib3d.estimateAffine3D_4(mat.nativeObj, mat2.nativeObj, dArray2));
        if (dArray != null) {
            dArray[0] = dArray2[0];
        }
        return mat3;
    }

    public static Mat estimateAffine3D(Mat mat, Mat mat2) {
        return new Mat(Calib3d.estimateAffine3D_5(mat.nativeObj, mat2.nativeObj));
    }

    public static int estimateTranslation3D(Mat mat, Mat mat2, Mat mat3, Mat mat4, double d, double d2) {
        return Calib3d.estimateTranslation3D_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, d, d2);
    }

    public static int estimateTranslation3D(Mat mat, Mat mat2, Mat mat3, Mat mat4, double d) {
        return Calib3d.estimateTranslation3D_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, d);
    }

    public static int estimateTranslation3D(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        return Calib3d.estimateTranslation3D_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static Mat estimateAffine2D(Mat mat, Mat mat2, Mat mat3, int n, double d, long l, double d2, long l2) {
        return new Mat(Calib3d.estimateAffine2D_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, d, l, d2, l2));
    }

    public static Mat estimateAffine2D(Mat mat, Mat mat2, Mat mat3, int n, double d, long l, double d2) {
        return new Mat(Calib3d.estimateAffine2D_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, d, l, d2));
    }

    public static Mat estimateAffine2D(Mat mat, Mat mat2, Mat mat3, int n, double d, long l) {
        return new Mat(Calib3d.estimateAffine2D_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, d, l));
    }

    public static Mat estimateAffine2D(Mat mat, Mat mat2, Mat mat3, int n, double d) {
        return new Mat(Calib3d.estimateAffine2D_3(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, d));
    }

    public static Mat estimateAffine2D(Mat mat, Mat mat2, Mat mat3, int n) {
        return new Mat(Calib3d.estimateAffine2D_4(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n));
    }

    public static Mat estimateAffine2D(Mat mat, Mat mat2, Mat mat3) {
        return new Mat(Calib3d.estimateAffine2D_5(mat.nativeObj, mat2.nativeObj, mat3.nativeObj));
    }

    public static Mat estimateAffine2D(Mat mat, Mat mat2) {
        return new Mat(Calib3d.estimateAffine2D_6(mat.nativeObj, mat2.nativeObj));
    }

    public static Mat estimateAffine2D(Mat mat, Mat mat2, Mat mat3, UsacParams usacParams) {
        return new Mat(Calib3d.estimateAffine2D_7(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, usacParams.getNativeObjAddr()));
    }

    public static Mat estimateAffinePartial2D(Mat mat, Mat mat2, Mat mat3, int n, double d, long l, double d2, long l2) {
        return new Mat(Calib3d.estimateAffinePartial2D_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, d, l, d2, l2));
    }

    public static Mat estimateAffinePartial2D(Mat mat, Mat mat2, Mat mat3, int n, double d, long l, double d2) {
        return new Mat(Calib3d.estimateAffinePartial2D_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, d, l, d2));
    }

    public static Mat estimateAffinePartial2D(Mat mat, Mat mat2, Mat mat3, int n, double d, long l) {
        return new Mat(Calib3d.estimateAffinePartial2D_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, d, l));
    }

    public static Mat estimateAffinePartial2D(Mat mat, Mat mat2, Mat mat3, int n, double d) {
        return new Mat(Calib3d.estimateAffinePartial2D_3(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, d));
    }

    public static Mat estimateAffinePartial2D(Mat mat, Mat mat2, Mat mat3, int n) {
        return new Mat(Calib3d.estimateAffinePartial2D_4(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n));
    }

    public static Mat estimateAffinePartial2D(Mat mat, Mat mat2, Mat mat3) {
        return new Mat(Calib3d.estimateAffinePartial2D_5(mat.nativeObj, mat2.nativeObj, mat3.nativeObj));
    }

    public static Mat estimateAffinePartial2D(Mat mat, Mat mat2) {
        return new Mat(Calib3d.estimateAffinePartial2D_6(mat.nativeObj, mat2.nativeObj));
    }

    public static int decomposeHomographyMat(Mat mat, Mat mat2, List<Mat> list, List<Mat> list2, List<Mat> list3) {
        Mat mat3 = new Mat();
        Mat mat4 = new Mat();
        Mat mat5 = new Mat();
        int n = Calib3d.decomposeHomographyMat_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj);
        Converters.Mat_to_vector_Mat(mat3, list);
        mat3.release();
        Converters.Mat_to_vector_Mat(mat4, list2);
        mat4.release();
        Converters.Mat_to_vector_Mat(mat5, list3);
        mat5.release();
        return n;
    }

    public static void filterHomographyDecompByVisibleRefpoints(List<Mat> list, List<Mat> list2, Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Mat mat5 = Converters.vector_Mat_to_Mat(list);
        Mat mat6 = Converters.vector_Mat_to_Mat(list2);
        Calib3d.filterHomographyDecompByVisibleRefpoints_0(mat5.nativeObj, mat6.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void filterHomographyDecompByVisibleRefpoints(List<Mat> list, List<Mat> list2, Mat mat, Mat mat2, Mat mat3) {
        Mat mat4 = Converters.vector_Mat_to_Mat(list);
        Mat mat5 = Converters.vector_Mat_to_Mat(list2);
        Calib3d.filterHomographyDecompByVisibleRefpoints_1(mat4.nativeObj, mat5.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void undistort(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5) {
        Calib3d.undistort_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj);
    }

    public static void undistort(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Calib3d.undistort_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void initUndistortRectifyMap(Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, int n, Mat mat5, Mat mat6) {
        Calib3d.initUndistortRectifyMap_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, n, mat5.nativeObj, mat6.nativeObj);
    }

    public static void initInverseRectificationMap(Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, int n, Mat mat5, Mat mat6) {
        Calib3d.initInverseRectificationMap_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, n, mat5.nativeObj, mat6.nativeObj);
    }

    public static Mat getDefaultNewCameraMatrix(Mat mat, Size size, boolean bl) {
        return new Mat(Calib3d.getDefaultNewCameraMatrix_0(mat.nativeObj, size.width, size.height, bl));
    }

    public static Mat getDefaultNewCameraMatrix(Mat mat, Size size) {
        return new Mat(Calib3d.getDefaultNewCameraMatrix_1(mat.nativeObj, size.width, size.height));
    }

    public static Mat getDefaultNewCameraMatrix(Mat mat) {
        return new Mat(Calib3d.getDefaultNewCameraMatrix_2(mat.nativeObj));
    }

    public static void undistortPoints(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        Calib3d.undistortPoints_0(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void undistortPoints(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, Mat mat, Mat mat2, Mat mat3) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        Calib3d.undistortPoints_1(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void undistortPoints(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, Mat mat, Mat mat2) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        Calib3d.undistortPoints_2(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, mat.nativeObj, mat2.nativeObj);
    }

    public static void undistortPointsIter(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, TermCriteria termCriteria) {
        Calib3d.undistortPointsIter_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
    }

    public static void undistortImagePoints(Mat mat, Mat mat2, Mat mat3, Mat mat4, TermCriteria termCriteria) {
        Calib3d.undistortImagePoints_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
    }

    public static void undistortImagePoints(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Calib3d.undistortImagePoints_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void fisheye_projectPoints(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, double d, Mat mat7) {
        Calib3d.fisheye_projectPoints_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, d, mat7.nativeObj);
    }

    public static void fisheye_projectPoints(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, double d) {
        Calib3d.fisheye_projectPoints_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, d);
    }

    public static void fisheye_projectPoints(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6) {
        Calib3d.fisheye_projectPoints_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj);
    }

    public static void fisheye_distortPoints(Mat mat, Mat mat2, Mat mat3, Mat mat4, double d) {
        Calib3d.fisheye_distortPoints_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, d);
    }

    public static void fisheye_distortPoints(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Calib3d.fisheye_distortPoints_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void fisheye_distortPoints(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, double d) {
        Calib3d.fisheye_distortPoints_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, d);
    }

    public static void fisheye_distortPoints(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5) {
        Calib3d.fisheye_distortPoints_3(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj);
    }

    public static void fisheye_undistortPoints(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, TermCriteria termCriteria) {
        Calib3d.fisheye_undistortPoints_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
    }

    public static void fisheye_undistortPoints(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6) {
        Calib3d.fisheye_undistortPoints_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj);
    }

    public static void fisheye_undistortPoints(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5) {
        Calib3d.fisheye_undistortPoints_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj);
    }

    public static void fisheye_undistortPoints(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Calib3d.fisheye_undistortPoints_3(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void fisheye_initUndistortRectifyMap(Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, int n, Mat mat5, Mat mat6) {
        Calib3d.fisheye_initUndistortRectifyMap_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, n, mat5.nativeObj, mat6.nativeObj);
    }

    public static void fisheye_undistortImage(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Size size) {
        Calib3d.fisheye_undistortImage_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, size.width, size.height);
    }

    public static void fisheye_undistortImage(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5) {
        Calib3d.fisheye_undistortImage_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj);
    }

    public static void fisheye_undistortImage(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Calib3d.fisheye_undistortImage_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void fisheye_estimateNewCameraMatrixForUndistortRectify(Mat mat, Mat mat2, Size size, Mat mat3, Mat mat4, double d, Size size2, double d2) {
        Calib3d.fisheye_estimateNewCameraMatrixForUndistortRectify_0(mat.nativeObj, mat2.nativeObj, size.width, size.height, mat3.nativeObj, mat4.nativeObj, d, size2.width, size2.height, d2);
    }

    public static void fisheye_estimateNewCameraMatrixForUndistortRectify(Mat mat, Mat mat2, Size size, Mat mat3, Mat mat4, double d, Size size2) {
        Calib3d.fisheye_estimateNewCameraMatrixForUndistortRectify_1(mat.nativeObj, mat2.nativeObj, size.width, size.height, mat3.nativeObj, mat4.nativeObj, d, size2.width, size2.height);
    }

    public static void fisheye_estimateNewCameraMatrixForUndistortRectify(Mat mat, Mat mat2, Size size, Mat mat3, Mat mat4, double d) {
        Calib3d.fisheye_estimateNewCameraMatrixForUndistortRectify_2(mat.nativeObj, mat2.nativeObj, size.width, size.height, mat3.nativeObj, mat4.nativeObj, d);
    }

    public static void fisheye_estimateNewCameraMatrixForUndistortRectify(Mat mat, Mat mat2, Size size, Mat mat3, Mat mat4) {
        Calib3d.fisheye_estimateNewCameraMatrixForUndistortRectify_3(mat.nativeObj, mat2.nativeObj, size.width, size.height, mat3.nativeObj, mat4.nativeObj);
    }

    public static double fisheye_calibrate(List<Mat> list, List<Mat> list2, Size size, Mat mat, Mat mat2, List<Mat> list3, List<Mat> list4, int n, TermCriteria termCriteria) {
        Mat mat3 = Converters.vector_Mat_to_Mat(list);
        Mat mat4 = Converters.vector_Mat_to_Mat(list2);
        Mat mat5 = new Mat();
        Mat mat6 = new Mat();
        double d = Calib3d.fisheye_calibrate_0(mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat.nativeObj, mat2.nativeObj, mat5.nativeObj, mat6.nativeObj, n, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
        Converters.Mat_to_vector_Mat(mat5, list3);
        mat5.release();
        Converters.Mat_to_vector_Mat(mat6, list4);
        mat6.release();
        return d;
    }

    public static double fisheye_calibrate(List<Mat> list, List<Mat> list2, Size size, Mat mat, Mat mat2, List<Mat> list3, List<Mat> list4, int n) {
        Mat mat3 = Converters.vector_Mat_to_Mat(list);
        Mat mat4 = Converters.vector_Mat_to_Mat(list2);
        Mat mat5 = new Mat();
        Mat mat6 = new Mat();
        double d = Calib3d.fisheye_calibrate_1(mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat.nativeObj, mat2.nativeObj, mat5.nativeObj, mat6.nativeObj, n);
        Converters.Mat_to_vector_Mat(mat5, list3);
        mat5.release();
        Converters.Mat_to_vector_Mat(mat6, list4);
        mat6.release();
        return d;
    }

    public static double fisheye_calibrate(List<Mat> list, List<Mat> list2, Size size, Mat mat, Mat mat2, List<Mat> list3, List<Mat> list4) {
        Mat mat3 = Converters.vector_Mat_to_Mat(list);
        Mat mat4 = Converters.vector_Mat_to_Mat(list2);
        Mat mat5 = new Mat();
        Mat mat6 = new Mat();
        double d = Calib3d.fisheye_calibrate_2(mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat.nativeObj, mat2.nativeObj, mat5.nativeObj, mat6.nativeObj);
        Converters.Mat_to_vector_Mat(mat5, list3);
        mat5.release();
        Converters.Mat_to_vector_Mat(mat6, list4);
        mat6.release();
        return d;
    }

    public static void fisheye_stereoRectify(Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, Mat mat10, Mat mat11, int n, Size size2, double d, double d2) {
        Calib3d.fisheye_stereoRectify_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, n, size2.width, size2.height, d, d2);
    }

    public static void fisheye_stereoRectify(Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, Mat mat10, Mat mat11, int n, Size size2, double d) {
        Calib3d.fisheye_stereoRectify_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, n, size2.width, size2.height, d);
    }

    public static void fisheye_stereoRectify(Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, Mat mat10, Mat mat11, int n, Size size2) {
        Calib3d.fisheye_stereoRectify_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, n, size2.width, size2.height);
    }

    public static void fisheye_stereoRectify(Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, Mat mat10, Mat mat11, int n) {
        Calib3d.fisheye_stereoRectify_3(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, n);
    }

    public static double fisheye_stereoCalibrate(List<Mat> list, List<Mat> list2, List<Mat> list3, Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, List<Mat> list4, List<Mat> list5, int n, TermCriteria termCriteria) {
        Mat mat7 = Converters.vector_Mat_to_Mat(list);
        Mat mat8 = Converters.vector_Mat_to_Mat(list2);
        Mat mat9 = Converters.vector_Mat_to_Mat(list3);
        Mat mat10 = new Mat();
        Mat mat11 = new Mat();
        double d = Calib3d.fisheye_stereoCalibrate_0(mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat10.nativeObj, mat11.nativeObj, n, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
        Converters.Mat_to_vector_Mat(mat10, list4);
        mat10.release();
        Converters.Mat_to_vector_Mat(mat11, list5);
        mat11.release();
        return d;
    }

    public static double fisheye_stereoCalibrate(List<Mat> list, List<Mat> list2, List<Mat> list3, Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, List<Mat> list4, List<Mat> list5, int n) {
        Mat mat7 = Converters.vector_Mat_to_Mat(list);
        Mat mat8 = Converters.vector_Mat_to_Mat(list2);
        Mat mat9 = Converters.vector_Mat_to_Mat(list3);
        Mat mat10 = new Mat();
        Mat mat11 = new Mat();
        double d = Calib3d.fisheye_stereoCalibrate_1(mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat10.nativeObj, mat11.nativeObj, n);
        Converters.Mat_to_vector_Mat(mat10, list4);
        mat10.release();
        Converters.Mat_to_vector_Mat(mat11, list5);
        mat11.release();
        return d;
    }

    public static double fisheye_stereoCalibrate(List<Mat> list, List<Mat> list2, List<Mat> list3, Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, List<Mat> list4, List<Mat> list5) {
        Mat mat7 = Converters.vector_Mat_to_Mat(list);
        Mat mat8 = Converters.vector_Mat_to_Mat(list2);
        Mat mat9 = Converters.vector_Mat_to_Mat(list3);
        Mat mat10 = new Mat();
        Mat mat11 = new Mat();
        double d = Calib3d.fisheye_stereoCalibrate_2(mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat10.nativeObj, mat11.nativeObj);
        Converters.Mat_to_vector_Mat(mat10, list4);
        mat10.release();
        Converters.Mat_to_vector_Mat(mat11, list5);
        mat11.release();
        return d;
    }

    public static double fisheye_stereoCalibrate(List<Mat> list, List<Mat> list2, List<Mat> list3, Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, int n, TermCriteria termCriteria) {
        Mat mat7 = Converters.vector_Mat_to_Mat(list);
        Mat mat8 = Converters.vector_Mat_to_Mat(list2);
        Mat mat9 = Converters.vector_Mat_to_Mat(list3);
        return Calib3d.fisheye_stereoCalibrate_3(mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, n, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
    }

    public static double fisheye_stereoCalibrate(List<Mat> list, List<Mat> list2, List<Mat> list3, Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, int n) {
        Mat mat7 = Converters.vector_Mat_to_Mat(list);
        Mat mat8 = Converters.vector_Mat_to_Mat(list2);
        Mat mat9 = Converters.vector_Mat_to_Mat(list3);
        return Calib3d.fisheye_stereoCalibrate_4(mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, n);
    }

    public static double fisheye_stereoCalibrate(List<Mat> list, List<Mat> list2, List<Mat> list3, Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6) {
        Mat mat7 = Converters.vector_Mat_to_Mat(list);
        Mat mat8 = Converters.vector_Mat_to_Mat(list2);
        Mat mat9 = Converters.vector_Mat_to_Mat(list3);
        return Calib3d.fisheye_stereoCalibrate_5(mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj);
    }

    public static boolean fisheye_solvePnP(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, boolean bl, int n, TermCriteria termCriteria) {
        return Calib3d.fisheye_solvePnP_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, bl, n, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
    }

    public static boolean fisheye_solvePnP(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, boolean bl, int n) {
        return Calib3d.fisheye_solvePnP_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, bl, n);
    }

    public static boolean fisheye_solvePnP(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, boolean bl) {
        return Calib3d.fisheye_solvePnP_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, bl);
    }

    public static boolean fisheye_solvePnP(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6) {
        return Calib3d.fisheye_solvePnP_3(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj);
    }

    public static boolean fisheye_solvePnPRansac(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, boolean bl, int n, float f, double d, Mat mat7, int n2, TermCriteria termCriteria) {
        return Calib3d.fisheye_solvePnPRansac_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, bl, n, f, d, mat7.nativeObj, n2, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
    }

    public static boolean fisheye_solvePnPRansac(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, boolean bl, int n, float f, double d, Mat mat7, int n2) {
        return Calib3d.fisheye_solvePnPRansac_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, bl, n, f, d, mat7.nativeObj, n2);
    }

    public static boolean fisheye_solvePnPRansac(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, boolean bl, int n, float f, double d, Mat mat7) {
        return Calib3d.fisheye_solvePnPRansac_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, bl, n, f, d, mat7.nativeObj);
    }

    public static boolean fisheye_solvePnPRansac(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, boolean bl, int n, float f, double d) {
        return Calib3d.fisheye_solvePnPRansac_3(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, bl, n, f, d);
    }

    public static boolean fisheye_solvePnPRansac(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, boolean bl, int n, float f) {
        return Calib3d.fisheye_solvePnPRansac_4(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, bl, n, f);
    }

    public static boolean fisheye_solvePnPRansac(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, boolean bl, int n) {
        return Calib3d.fisheye_solvePnPRansac_5(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, bl, n);
    }

    public static boolean fisheye_solvePnPRansac(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, boolean bl) {
        return Calib3d.fisheye_solvePnPRansac_6(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, bl);
    }

    public static boolean fisheye_solvePnPRansac(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6) {
        return Calib3d.fisheye_solvePnPRansac_7(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj);
    }

    private static native void Rodrigues_0(long var0, long var2, long var4);

    private static native void Rodrigues_1(long var0, long var2);

    private static native long findHomography_0(long var0, long var2, int var4, double var5, long var7, int var9, double var10);

    private static native long findHomography_1(long var0, long var2, int var4, double var5, long var7, int var9);

    private static native long findHomography_2(long var0, long var2, int var4, double var5, long var7);

    private static native long findHomography_3(long var0, long var2, int var4, double var5);

    private static native long findHomography_4(long var0, long var2, int var4);

    private static native long findHomography_5(long var0, long var2);

    private static native long findHomography_6(long var0, long var2, long var4, long var6);

    private static native double[] RQDecomp3x3_0(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native double[] RQDecomp3x3_1(long var0, long var2, long var4, long var6, long var8);

    private static native double[] RQDecomp3x3_2(long var0, long var2, long var4, long var6);

    private static native double[] RQDecomp3x3_3(long var0, long var2, long var4);

    private static native void decomposeProjectionMatrix_0(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    private static native void decomposeProjectionMatrix_1(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    private static native void decomposeProjectionMatrix_2(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void decomposeProjectionMatrix_3(long var0, long var2, long var4, long var6, long var8);

    private static native void decomposeProjectionMatrix_4(long var0, long var2, long var4, long var6);

    private static native void matMulDeriv_0(long var0, long var2, long var4, long var6);

    private static native void composeRT_0(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16, long var18, long var20, long var22, long var24, long var26);

    private static native void composeRT_1(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16, long var18, long var20, long var22, long var24);

    private static native void composeRT_2(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16, long var18, long var20, long var22);

    private static native void composeRT_3(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16, long var18, long var20);

    private static native void composeRT_4(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16, long var18);

    private static native void composeRT_5(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16);

    private static native void composeRT_6(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    private static native void composeRT_7(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    private static native void composeRT_8(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void projectPoints_0(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14);

    private static native void projectPoints_1(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    private static native void projectPoints_2(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native boolean solvePnP_0(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12, int var13);

    private static native boolean solvePnP_1(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12);

    private static native boolean solvePnP_2(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native boolean solvePnPRansac_0(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12, int var13, float var14, double var15, long var17, int var19);

    private static native boolean solvePnPRansac_1(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12, int var13, float var14, double var15, long var17);

    private static native boolean solvePnPRansac_2(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12, int var13, float var14, double var15);

    private static native boolean solvePnPRansac_3(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12, int var13, float var14);

    private static native boolean solvePnPRansac_4(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12, int var13);

    private static native boolean solvePnPRansac_5(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12);

    private static native boolean solvePnPRansac_6(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native boolean solvePnPRansac_7(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    private static native boolean solvePnPRansac_8(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    private static native int solveP3P_0(long var0, long var2, long var4, long var6, long var8, long var10, int var12);

    private static native void solvePnPRefineLM_0(long var0, long var2, long var4, long var6, long var8, long var10, int var12, int var13, double var14);

    private static native void solvePnPRefineLM_1(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void solvePnPRefineVVS_0(long var0, long var2, long var4, long var6, long var8, long var10, int var12, int var13, double var14, double var16);

    private static native void solvePnPRefineVVS_1(long var0, long var2, long var4, long var6, long var8, long var10, int var12, int var13, double var14);

    private static native void solvePnPRefineVVS_2(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native int solvePnPGeneric_0(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12, int var13, long var14, long var16, long var18);

    private static native int solvePnPGeneric_1(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12, int var13, long var14, long var16);

    private static native int solvePnPGeneric_2(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12, int var13, long var14);

    private static native int solvePnPGeneric_3(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12, int var13);

    private static native int solvePnPGeneric_4(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12);

    private static native int solvePnPGeneric_5(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native long initCameraMatrix2D_0(long var0, long var2, double var4, double var6, double var8);

    private static native long initCameraMatrix2D_1(long var0, long var2, double var4, double var6);

    private static native boolean findChessboardCorners_0(long var0, double var2, double var4, long var6, int var8);

    private static native boolean findChessboardCorners_1(long var0, double var2, double var4, long var6);

    private static native boolean checkChessboard_0(long var0, double var2, double var4);

    private static native boolean findChessboardCornersSBWithMeta_0(long var0, double var2, double var4, long var6, int var8, long var9);

    private static native boolean findChessboardCornersSB_0(long var0, double var2, double var4, long var6, int var8);

    private static native boolean findChessboardCornersSB_1(long var0, double var2, double var4, long var6);

    private static native double[] estimateChessboardSharpness_0(long var0, double var2, double var4, long var6, float var8, boolean var9, long var10);

    private static native double[] estimateChessboardSharpness_1(long var0, double var2, double var4, long var6, float var8, boolean var9);

    private static native double[] estimateChessboardSharpness_2(long var0, double var2, double var4, long var6, float var8);

    private static native double[] estimateChessboardSharpness_3(long var0, double var2, double var4, long var6);

    private static native boolean find4QuadCornerSubpix_0(long var0, long var2, double var4, double var6);

    private static native void drawChessboardCorners_0(long var0, double var2, double var4, long var6, boolean var8);

    private static native void drawFrameAxes_0(long var0, long var2, long var4, long var6, long var8, float var10, int var11);

    private static native void drawFrameAxes_1(long var0, long var2, long var4, long var6, long var8, float var10);

    private static native boolean findCirclesGrid_0(long var0, double var2, double var4, long var6, int var8);

    private static native boolean findCirclesGrid_2(long var0, double var2, double var4, long var6);

    private static native double calibrateCameraExtended_0(long var0, long var2, double var4, double var6, long var8, long var10, long var12, long var14, long var16, long var18, long var20, int var22, int var23, int var24, double var25);

    private static native double calibrateCameraExtended_1(long var0, long var2, double var4, double var6, long var8, long var10, long var12, long var14, long var16, long var18, long var20, int var22);

    private static native double calibrateCameraExtended_2(long var0, long var2, double var4, double var6, long var8, long var10, long var12, long var14, long var16, long var18, long var20);

    private static native double calibrateCamera_0(long var0, long var2, double var4, double var6, long var8, long var10, long var12, long var14, int var16, int var17, int var18, double var19);

    private static native double calibrateCamera_1(long var0, long var2, double var4, double var6, long var8, long var10, long var12, long var14, int var16);

    private static native double calibrateCamera_2(long var0, long var2, double var4, double var6, long var8, long var10, long var12, long var14);

    private static native double calibrateCameraROExtended_0(long var0, long var2, double var4, double var6, int var8, long var9, long var11, long var13, long var15, long var17, long var19, long var21, long var23, long var25, int var27, int var28, int var29, double var30);

    private static native double calibrateCameraROExtended_1(long var0, long var2, double var4, double var6, int var8, long var9, long var11, long var13, long var15, long var17, long var19, long var21, long var23, long var25, int var27);

    private static native double calibrateCameraROExtended_2(long var0, long var2, double var4, double var6, int var8, long var9, long var11, long var13, long var15, long var17, long var19, long var21, long var23, long var25);

    private static native double calibrateCameraRO_0(long var0, long var2, double var4, double var6, int var8, long var9, long var11, long var13, long var15, long var17, int var19, int var20, int var21, double var22);

    private static native double calibrateCameraRO_1(long var0, long var2, double var4, double var6, int var8, long var9, long var11, long var13, long var15, long var17, int var19);

    private static native double calibrateCameraRO_2(long var0, long var2, double var4, double var6, int var8, long var9, long var11, long var13, long var15, long var17);

    private static native void calibrationMatrixValues_0(long var0, double var2, double var4, double var6, double var8, double[] var10, double[] var11, double[] var12, double[] var13, double[] var14);

    private static native double stereoCalibrateExtended_0(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14, double var16, long var18, long var20, long var22, long var24, long var26, long var28, long var30, int var32, int var33, int var34, double var35);

    private static native double stereoCalibrateExtended_1(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14, double var16, long var18, long var20, long var22, long var24, long var26, long var28, long var30, int var32);

    private static native double stereoCalibrateExtended_2(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14, double var16, long var18, long var20, long var22, long var24, long var26, long var28, long var30);

    private static native double stereoCalibrate_0(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14, double var16, long var18, long var20, long var22, long var24, int var26, int var27, int var28, double var29);

    private static native double stereoCalibrate_1(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14, double var16, long var18, long var20, long var22, long var24, int var26);

    private static native double stereoCalibrate_2(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14, double var16, long var18, long var20, long var22, long var24);

    private static native double stereoCalibrate_3(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14, double var16, long var18, long var20, long var22, long var24, long var26, int var28, int var29, int var30, double var31);

    private static native double stereoCalibrate_4(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14, double var16, long var18, long var20, long var22, long var24, long var26, int var28);

    private static native double stereoCalibrate_5(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14, double var16, long var18, long var20, long var22, long var24, long var26);

    private static native void stereoRectify_0(long var0, long var2, long var4, long var6, double var8, double var10, long var12, long var14, long var16, long var18, long var20, long var22, long var24, int var26, double var27, double var29, double var31, double[] var33, double[] var34);

    private static native void stereoRectify_1(long var0, long var2, long var4, long var6, double var8, double var10, long var12, long var14, long var16, long var18, long var20, long var22, long var24, int var26, double var27, double var29, double var31, double[] var33);

    private static native void stereoRectify_2(long var0, long var2, long var4, long var6, double var8, double var10, long var12, long var14, long var16, long var18, long var20, long var22, long var24, int var26, double var27, double var29, double var31);

    private static native void stereoRectify_3(long var0, long var2, long var4, long var6, double var8, double var10, long var12, long var14, long var16, long var18, long var20, long var22, long var24, int var26, double var27);

    private static native void stereoRectify_4(long var0, long var2, long var4, long var6, double var8, double var10, long var12, long var14, long var16, long var18, long var20, long var22, long var24, int var26);

    private static native void stereoRectify_5(long var0, long var2, long var4, long var6, double var8, double var10, long var12, long var14, long var16, long var18, long var20, long var22, long var24);

    private static native boolean stereoRectifyUncalibrated_0(long var0, long var2, long var4, double var6, double var8, long var10, long var12, double var14);

    private static native boolean stereoRectifyUncalibrated_1(long var0, long var2, long var4, double var6, double var8, long var10, long var12);

    private static native float rectify3Collinear_0(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, double var16, double var18, long var20, long var22, long var24, long var26, long var28, long var30, long var32, long var34, long var36, long var38, long var40, double var42, double var44, double var46, double[] var48, double[] var49, int var50);

    private static native long getOptimalNewCameraMatrix_0(long var0, long var2, double var4, double var6, double var8, double var10, double var12, double[] var14, boolean var15);

    private static native long getOptimalNewCameraMatrix_1(long var0, long var2, double var4, double var6, double var8, double var10, double var12, double[] var14);

    private static native long getOptimalNewCameraMatrix_2(long var0, long var2, double var4, double var6, double var8, double var10, double var12);

    private static native long getOptimalNewCameraMatrix_3(long var0, long var2, double var4, double var6, double var8);

    private static native void calibrateHandEye_0(long var0, long var2, long var4, long var6, long var8, long var10, int var12);

    private static native void calibrateHandEye_1(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void calibrateRobotWorldHandEye_0(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, int var16);

    private static native void calibrateRobotWorldHandEye_1(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    private static native void convertPointsToHomogeneous_0(long var0, long var2);

    private static native void convertPointsFromHomogeneous_0(long var0, long var2);

    private static native long findFundamentalMat_0(long var0, long var2, int var4, double var5, double var7, int var9, long var10);

    private static native long findFundamentalMat_1(long var0, long var2, int var4, double var5, double var7, int var9);

    private static native long findFundamentalMat_2(long var0, long var2, int var4, double var5, double var7, long var9);

    private static native long findFundamentalMat_3(long var0, long var2, int var4, double var5, double var7);

    private static native long findFundamentalMat_4(long var0, long var2, int var4, double var5);

    private static native long findFundamentalMat_5(long var0, long var2, int var4);

    private static native long findFundamentalMat_6(long var0, long var2);

    private static native long findFundamentalMat_7(long var0, long var2, long var4, long var6);

    private static native long findEssentialMat_0(long var0, long var2, long var4, int var6, double var7, double var9, int var11, long var12);

    private static native long findEssentialMat_1(long var0, long var2, long var4, int var6, double var7, double var9, int var11);

    private static native long findEssentialMat_2(long var0, long var2, long var4, int var6, double var7, double var9);

    private static native long findEssentialMat_3(long var0, long var2, long var4, int var6, double var7);

    private static native long findEssentialMat_4(long var0, long var2, long var4, int var6);

    private static native long findEssentialMat_5(long var0, long var2, long var4);

    private static native long findEssentialMat_6(long var0, long var2, double var4, double var6, double var8, int var10, double var11, double var13, int var15, long var16);

    private static native long findEssentialMat_7(long var0, long var2, double var4, double var6, double var8, int var10, double var11, double var13, int var15);

    private static native long findEssentialMat_8(long var0, long var2, double var4, double var6, double var8, int var10, double var11, double var13);

    private static native long findEssentialMat_9(long var0, long var2, double var4, double var6, double var8, int var10, double var11);

    private static native long findEssentialMat_10(long var0, long var2, double var4, double var6, double var8, int var10);

    private static native long findEssentialMat_11(long var0, long var2, double var4, double var6, double var8);

    private static native long findEssentialMat_12(long var0, long var2, double var4);

    private static native long findEssentialMat_13(long var0, long var2);

    private static native long findEssentialMat_14(long var0, long var2, long var4, long var6, long var8, long var10, int var12, double var13, double var15, long var17);

    private static native long findEssentialMat_15(long var0, long var2, long var4, long var6, long var8, long var10, int var12, double var13, double var15);

    private static native long findEssentialMat_16(long var0, long var2, long var4, long var6, long var8, long var10, int var12, double var13);

    private static native long findEssentialMat_17(long var0, long var2, long var4, long var6, long var8, long var10, int var12);

    private static native long findEssentialMat_18(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native long findEssentialMat_19(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    private static native void decomposeEssentialMat_0(long var0, long var2, long var4, long var6);

    private static native int recoverPose_0(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16, int var18, double var19, double var21, long var23);

    private static native int recoverPose_1(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16, int var18, double var19, double var21);

    private static native int recoverPose_2(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16, int var18, double var19);

    private static native int recoverPose_3(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16, int var18);

    private static native int recoverPose_4(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16);

    private static native int recoverPose_5(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    private static native int recoverPose_6(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native int recoverPose_7(long var0, long var2, long var4, long var6, long var8, double var10, double var12, double var14, long var16);

    private static native int recoverPose_8(long var0, long var2, long var4, long var6, long var8, double var10, double var12, double var14);

    private static native int recoverPose_9(long var0, long var2, long var4, long var6, long var8, double var10);

    private static native int recoverPose_10(long var0, long var2, long var4, long var6, long var8);

    private static native int recoverPose_11(long var0, long var2, long var4, long var6, long var8, long var10, double var12, long var14, long var16);

    private static native int recoverPose_12(long var0, long var2, long var4, long var6, long var8, long var10, double var12, long var14);

    private static native int recoverPose_13(long var0, long var2, long var4, long var6, long var8, long var10, double var12);

    private static native void computeCorrespondEpilines_0(long var0, int var2, long var3, long var5);

    private static native void triangulatePoints_0(long var0, long var2, long var4, long var6, long var8);

    private static native void correctMatches_0(long var0, long var2, long var4, long var6, long var8);

    private static native void filterSpeckles_0(long var0, double var2, int var4, double var5, long var7);

    private static native void filterSpeckles_1(long var0, double var2, int var4, double var5);

    private static native double[] getValidDisparityROI_0(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    private static native void validateDisparity_0(long var0, long var2, int var4, int var5, int var6);

    private static native void validateDisparity_1(long var0, long var2, int var4, int var5);

    private static native void reprojectImageTo3D_0(long var0, long var2, long var4, boolean var6, int var7);

    private static native void reprojectImageTo3D_1(long var0, long var2, long var4, boolean var6);

    private static native void reprojectImageTo3D_2(long var0, long var2, long var4);

    private static native double sampsonDistance_0(long var0, long var2, long var4);

    private static native int estimateAffine3D_0(long var0, long var2, long var4, long var6, double var8, double var10);

    private static native int estimateAffine3D_1(long var0, long var2, long var4, long var6, double var8);

    private static native int estimateAffine3D_2(long var0, long var2, long var4, long var6);

    private static native long estimateAffine3D_3(long var0, long var2, double[] var4, boolean var5);

    private static native long estimateAffine3D_4(long var0, long var2, double[] var4);

    private static native long estimateAffine3D_5(long var0, long var2);

    private static native int estimateTranslation3D_0(long var0, long var2, long var4, long var6, double var8, double var10);

    private static native int estimateTranslation3D_1(long var0, long var2, long var4, long var6, double var8);

    private static native int estimateTranslation3D_2(long var0, long var2, long var4, long var6);

    private static native long estimateAffine2D_0(long var0, long var2, long var4, int var6, double var7, long var9, double var11, long var13);

    private static native long estimateAffine2D_1(long var0, long var2, long var4, int var6, double var7, long var9, double var11);

    private static native long estimateAffine2D_2(long var0, long var2, long var4, int var6, double var7, long var9);

    private static native long estimateAffine2D_3(long var0, long var2, long var4, int var6, double var7);

    private static native long estimateAffine2D_4(long var0, long var2, long var4, int var6);

    private static native long estimateAffine2D_5(long var0, long var2, long var4);

    private static native long estimateAffine2D_6(long var0, long var2);

    private static native long estimateAffine2D_7(long var0, long var2, long var4, long var6);

    private static native long estimateAffinePartial2D_0(long var0, long var2, long var4, int var6, double var7, long var9, double var11, long var13);

    private static native long estimateAffinePartial2D_1(long var0, long var2, long var4, int var6, double var7, long var9, double var11);

    private static native long estimateAffinePartial2D_2(long var0, long var2, long var4, int var6, double var7, long var9);

    private static native long estimateAffinePartial2D_3(long var0, long var2, long var4, int var6, double var7);

    private static native long estimateAffinePartial2D_4(long var0, long var2, long var4, int var6);

    private static native long estimateAffinePartial2D_5(long var0, long var2, long var4);

    private static native long estimateAffinePartial2D_6(long var0, long var2);

    private static native int decomposeHomographyMat_0(long var0, long var2, long var4, long var6, long var8);

    private static native void filterHomographyDecompByVisibleRefpoints_0(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void filterHomographyDecompByVisibleRefpoints_1(long var0, long var2, long var4, long var6, long var8);

    private static native void undistort_0(long var0, long var2, long var4, long var6, long var8);

    private static native void undistort_1(long var0, long var2, long var4, long var6);

    private static native void initUndistortRectifyMap_0(long var0, long var2, long var4, long var6, double var8, double var10, int var12, long var13, long var15);

    private static native void initInverseRectificationMap_0(long var0, long var2, long var4, long var6, double var8, double var10, int var12, long var13, long var15);

    private static native long getDefaultNewCameraMatrix_0(long var0, double var2, double var4, boolean var6);

    private static native long getDefaultNewCameraMatrix_1(long var0, double var2, double var4);

    private static native long getDefaultNewCameraMatrix_2(long var0);

    private static native void undistortPoints_0(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void undistortPoints_1(long var0, long var2, long var4, long var6, long var8);

    private static native void undistortPoints_2(long var0, long var2, long var4, long var6);

    private static native void undistortPointsIter_0(long var0, long var2, long var4, long var6, long var8, long var10, int var12, int var13, double var14);

    private static native void undistortImagePoints_0(long var0, long var2, long var4, long var6, int var8, int var9, double var10);

    private static native void undistortImagePoints_1(long var0, long var2, long var4, long var6);

    private static native void fisheye_projectPoints_0(long var0, long var2, long var4, long var6, long var8, long var10, double var12, long var14);

    private static native void fisheye_projectPoints_1(long var0, long var2, long var4, long var6, long var8, long var10, double var12);

    private static native void fisheye_projectPoints_2(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void fisheye_distortPoints_0(long var0, long var2, long var4, long var6, double var8);

    private static native void fisheye_distortPoints_1(long var0, long var2, long var4, long var6);

    private static native void fisheye_distortPoints_2(long var0, long var2, long var4, long var6, long var8, double var10);

    private static native void fisheye_distortPoints_3(long var0, long var2, long var4, long var6, long var8);

    private static native void fisheye_undistortPoints_0(long var0, long var2, long var4, long var6, long var8, long var10, int var12, int var13, double var14);

    private static native void fisheye_undistortPoints_1(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void fisheye_undistortPoints_2(long var0, long var2, long var4, long var6, long var8);

    private static native void fisheye_undistortPoints_3(long var0, long var2, long var4, long var6);

    private static native void fisheye_initUndistortRectifyMap_0(long var0, long var2, long var4, long var6, double var8, double var10, int var12, long var13, long var15);

    private static native void fisheye_undistortImage_0(long var0, long var2, long var4, long var6, long var8, double var10, double var12);

    private static native void fisheye_undistortImage_1(long var0, long var2, long var4, long var6, long var8);

    private static native void fisheye_undistortImage_2(long var0, long var2, long var4, long var6);

    private static native void fisheye_estimateNewCameraMatrixForUndistortRectify_0(long var0, long var2, double var4, double var6, long var8, long var10, double var12, double var14, double var16, double var18);

    private static native void fisheye_estimateNewCameraMatrixForUndistortRectify_1(long var0, long var2, double var4, double var6, long var8, long var10, double var12, double var14, double var16);

    private static native void fisheye_estimateNewCameraMatrixForUndistortRectify_2(long var0, long var2, double var4, double var6, long var8, long var10, double var12);

    private static native void fisheye_estimateNewCameraMatrixForUndistortRectify_3(long var0, long var2, double var4, double var6, long var8, long var10);

    private static native double fisheye_calibrate_0(long var0, long var2, double var4, double var6, long var8, long var10, long var12, long var14, int var16, int var17, int var18, double var19);

    private static native double fisheye_calibrate_1(long var0, long var2, double var4, double var6, long var8, long var10, long var12, long var14, int var16);

    private static native double fisheye_calibrate_2(long var0, long var2, double var4, double var6, long var8, long var10, long var12, long var14);

    private static native void fisheye_stereoRectify_0(long var0, long var2, long var4, long var6, double var8, double var10, long var12, long var14, long var16, long var18, long var20, long var22, long var24, int var26, double var27, double var29, double var31, double var33);

    private static native void fisheye_stereoRectify_1(long var0, long var2, long var4, long var6, double var8, double var10, long var12, long var14, long var16, long var18, long var20, long var22, long var24, int var26, double var27, double var29, double var31);

    private static native void fisheye_stereoRectify_2(long var0, long var2, long var4, long var6, double var8, double var10, long var12, long var14, long var16, long var18, long var20, long var22, long var24, int var26, double var27, double var29);

    private static native void fisheye_stereoRectify_3(long var0, long var2, long var4, long var6, double var8, double var10, long var12, long var14, long var16, long var18, long var20, long var22, long var24, int var26);

    private static native double fisheye_stereoCalibrate_0(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14, double var16, long var18, long var20, long var22, long var24, int var26, int var27, int var28, double var29);

    private static native double fisheye_stereoCalibrate_1(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14, double var16, long var18, long var20, long var22, long var24, int var26);

    private static native double fisheye_stereoCalibrate_2(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14, double var16, long var18, long var20, long var22, long var24);

    private static native double fisheye_stereoCalibrate_3(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14, double var16, long var18, long var20, int var22, int var23, int var24, double var25);

    private static native double fisheye_stereoCalibrate_4(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14, double var16, long var18, long var20, int var22);

    private static native double fisheye_stereoCalibrate_5(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14, double var16, long var18, long var20);

    private static native boolean fisheye_solvePnP_0(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12, int var13, int var14, int var15, double var16);

    private static native boolean fisheye_solvePnP_1(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12, int var13);

    private static native boolean fisheye_solvePnP_2(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12);

    private static native boolean fisheye_solvePnP_3(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native boolean fisheye_solvePnPRansac_0(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12, int var13, float var14, double var15, long var17, int var19, int var20, int var21, double var22);

    private static native boolean fisheye_solvePnPRansac_1(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12, int var13, float var14, double var15, long var17, int var19);

    private static native boolean fisheye_solvePnPRansac_2(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12, int var13, float var14, double var15, long var17);

    private static native boolean fisheye_solvePnPRansac_3(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12, int var13, float var14, double var15);

    private static native boolean fisheye_solvePnPRansac_4(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12, int var13, float var14);

    private static native boolean fisheye_solvePnPRansac_5(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12, int var13);

    private static native boolean fisheye_solvePnPRansac_6(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12);

    private static native boolean fisheye_solvePnPRansac_7(long var0, long var2, long var4, long var6, long var8, long var10);
}

