/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import java.util.Arrays;
import java.util.List;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Point3;
import org.opencv.core.Range;

public class MatOfPoint3f
extends Mat {
    private static final int _depth = 5;
    private static final int _channels = 3;

    public MatOfPoint3f() {
    }

    protected MatOfPoint3f(long l) {
        super(l);
        if (!this.empty() && this.checkVector(3, 5) < 0) {
            throw new IllegalArgumentException("Incompatible Mat");
        }
    }

    public static MatOfPoint3f fromNativeAddr(long l) {
        return new MatOfPoint3f(l);
    }

    public MatOfPoint3f(Mat mat) {
        super(mat, Range.all());
        if (!this.empty() && this.checkVector(3, 5) < 0) {
            throw new IllegalArgumentException("Incompatible Mat");
        }
    }

    public MatOfPoint3f(Point3 ... point3Array) {
        this.fromArray(point3Array);
    }

    public void alloc(int n) {
        if (n > 0) {
            super.create(n, 1, CvType.makeType(5, 3));
        }
    }

    public void fromArray(Point3 ... point3Array) {
        if (point3Array == null || point3Array.length == 0) {
            return;
        }
        int n = point3Array.length;
        this.alloc(n);
        float[] fArray = new float[n * 3];
        for (int i = 0; i < n; ++i) {
            Point3 point3 = point3Array[i];
            fArray[3 * i + 0] = (float)point3.x;
            fArray[3 * i + 1] = (float)point3.y;
            fArray[3 * i + 2] = (float)point3.z;
        }
        this.put(0, 0, fArray);
    }

    public Point3[] toArray() {
        int n = (int)this.total();
        Point3[] point3Array = new Point3[n];
        if (n == 0) {
            return point3Array;
        }
        float[] fArray = new float[n * 3];
        this.get(0, 0, fArray);
        for (int i = 0; i < n; ++i) {
            point3Array[i] = new Point3(fArray[i * 3], fArray[i * 3 + 1], fArray[i * 3 + 2]);
        }
        return point3Array;
    }

    public void fromList(List<Point3> list) {
        Point3[] point3Array = list.toArray(new Point3[0]);
        this.fromArray(point3Array);
    }

    public List<Point3> toList() {
        Point3[] point3Array = this.toArray();
        return Arrays.asList(point3Array);
    }
}

