/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import org.opencv.core.Point;
import org.opencv.core.Size;

public class Rect {
    public int x;
    public int y;
    public int width;
    public int height;

    public Rect(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public Rect() {
        this(0, 0, 0, 0);
    }

    public Rect(Point point, Point point2) {
        this.x = (int)(point.x < point2.x ? point.x : point2.x);
        this.y = (int)(point.y < point2.y ? point.y : point2.y);
        this.width = (int)(point.x > point2.x ? point.x : point2.x) - this.x;
        this.height = (int)(point.y > point2.y ? point.y : point2.y) - this.y;
    }

    public Rect(Point point, Size size) {
        this((int)point.x, (int)point.y, (int)size.width, (int)size.height);
    }

    public Rect(double[] dArray) {
        this.set(dArray);
    }

    public void set(double[] dArray) {
        if (dArray != null) {
            this.x = dArray.length > 0 ? (int)dArray[0] : 0;
            this.y = dArray.length > 1 ? (int)dArray[1] : 0;
            this.width = dArray.length > 2 ? (int)dArray[2] : 0;
            this.height = dArray.length > 3 ? (int)dArray[3] : 0;
        } else {
            this.x = 0;
            this.y = 0;
            this.width = 0;
            this.height = 0;
        }
    }

    public Rect clone() {
        return new Rect(this.x, this.y, this.width, this.height);
    }

    public Point tl() {
        return new Point(this.x, this.y);
    }

    public Point br() {
        return new Point(this.x + this.width, this.y + this.height);
    }

    public Size size() {
        return new Size(this.width, this.height);
    }

    public double area() {
        return this.width * this.height;
    }

    public boolean empty() {
        return this.width <= 0 || this.height <= 0;
    }

    public boolean contains(Point point) {
        return (double)this.x <= point.x && point.x < (double)(this.x + this.width) && (double)this.y <= point.y && point.y < (double)(this.y + this.height);
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.height);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.width);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.x);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Rect)) {
            return false;
        }
        Rect rect = (Rect)object;
        return this.x == rect.x && this.y == rect.y && this.width == rect.width && this.height == rect.height;
    }

    public String toString() {
        return "{" + this.x + ", " + this.y + ", " + this.width + "x" + this.height + "}";
    }
}

