/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.imgcodecs;

import java.util.ArrayList;
import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfInt;
import org.opencv.core.Scalar;
import org.opencv.utils.Converters;

public class Animation {
    protected final long nativeObj;

    protected Animation(long l) {
        this.nativeObj = l;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static Animation __fromPtr__(long l) {
        return new Animation(l);
    }

    public Animation(int n, Scalar scalar) {
        this.nativeObj = Animation.Animation_0(n, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public Animation(int n) {
        this.nativeObj = Animation.Animation_1(n);
    }

    public Animation() {
        this.nativeObj = Animation.Animation_2();
    }

    public int get_loop_count() {
        return Animation.get_loop_count_0(this.nativeObj);
    }

    public void set_loop_count(int n) {
        Animation.set_loop_count_0(this.nativeObj, n);
    }

    public Scalar get_bgcolor() {
        return new Scalar(Animation.get_bgcolor_0(this.nativeObj));
    }

    public void set_bgcolor(Scalar scalar) {
        Animation.set_bgcolor_0(this.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public MatOfInt get_durations() {
        return MatOfInt.fromNativeAddr(Animation.get_durations_0(this.nativeObj));
    }

    public void set_durations(MatOfInt matOfInt) {
        MatOfInt matOfInt2 = matOfInt;
        Animation.set_durations_0(this.nativeObj, matOfInt2.nativeObj);
    }

    public List<Mat> get_frames() {
        ArrayList<Mat> arrayList = new ArrayList<Mat>();
        Mat mat = new Mat(Animation.get_frames_0(this.nativeObj));
        Converters.Mat_to_vector_Mat(mat, arrayList);
        return arrayList;
    }

    public void set_frames(List<Mat> list) {
        Mat mat = Converters.vector_Mat_to_Mat(list);
        Animation.set_frames_0(this.nativeObj, mat.nativeObj);
    }

    public Mat get_still_image() {
        return new Mat(Animation.get_still_image_0(this.nativeObj));
    }

    public void set_still_image(Mat mat) {
        Animation.set_still_image_0(this.nativeObj, mat.nativeObj);
    }

    protected void finalize() throws Throwable {
        Animation.delete(this.nativeObj);
    }

    private static native long Animation_0(int var0, double var1, double var3, double var5, double var7);

    private static native long Animation_1(int var0);

    private static native long Animation_2();

    private static native int get_loop_count_0(long var0);

    private static native void set_loop_count_0(long var0, int var2);

    private static native double[] get_bgcolor_0(long var0);

    private static native void set_bgcolor_0(long var0, double var2, double var4, double var6, double var8);

    private static native long get_durations_0(long var0);

    private static native void set_durations_0(long var0, long var2);

    private static native long get_frames_0(long var0);

    private static native void set_frames_0(long var0, long var2);

    private static native long get_still_image_0(long var0);

    private static native void set_still_image_0(long var0, long var2);

    private static native void delete(long var0);
}

