/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import java.util.Arrays;
import java.util.List;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Range;

public class MatOfPoint2f
extends Mat {
    private static final int _depth = 5;
    private static final int _channels = 2;

    public MatOfPoint2f() {
    }

    protected MatOfPoint2f(long l) {
        super(l);
        if (!this.empty() && this.checkVector(2, 5) < 0) {
            throw new IllegalArgumentException("Incompatible Mat");
        }
    }

    public static MatOfPoint2f fromNativeAddr(long l) {
        return new MatOfPoint2f(l);
    }

    public MatOfPoint2f(Mat mat) {
        super(mat, Range.all());
        if (!this.empty() && this.checkVector(2, 5) < 0) {
            throw new IllegalArgumentException("Incompatible Mat");
        }
    }

    public MatOfPoint2f(Point ... pointArray) {
        this.fromArray(pointArray);
    }

    public void alloc(int n) {
        if (n > 0) {
            super.create(n, 1, CvType.makeType(5, 2));
        }
    }

    public void fromArray(Point ... pointArray) {
        if (pointArray == null || pointArray.length == 0) {
            return;
        }
        int n = pointArray.length;
        this.alloc(n);
        float[] fArray = new float[n * 2];
        for (int i = 0; i < n; ++i) {
            Point point = pointArray[i];
            fArray[2 * i + 0] = (float)point.x;
            fArray[2 * i + 1] = (float)point.y;
        }
        this.put(0, 0, fArray);
    }

    public Point[] toArray() {
        int n = (int)this.total();
        Point[] pointArray = new Point[n];
        if (n == 0) {
            return pointArray;
        }
        float[] fArray = new float[n * 2];
        this.get(0, 0, fArray);
        for (int i = 0; i < n; ++i) {
            pointArray[i] = new Point(fArray[i * 2], fArray[i * 2 + 1]);
        }
        return pointArray;
    }

    public void fromList(List<Point> list) {
        Point[] pointArray = list.toArray(new Point[0]);
        this.fromArray(pointArray);
    }

    public List<Point> toList() {
        Point[] pointArray = this.toArray();
        return Arrays.asList(pointArray);
    }
}

