/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.objdetect;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.utils.Converters;

public class GraphicalCodeDetector {
    protected final long nativeObj;

    protected GraphicalCodeDetector(long l) {
        this.nativeObj = l;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static GraphicalCodeDetector __fromPtr__(long l) {
        return new GraphicalCodeDetector(l);
    }

    public boolean detect(Mat mat, Mat mat2) {
        return GraphicalCodeDetector.detect_0(this.nativeObj, mat.nativeObj, mat2.nativeObj);
    }

    public String decode(Mat mat, Mat mat2, Mat mat3) {
        return GraphicalCodeDetector.decode_0(this.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public String decode(Mat mat, Mat mat2) {
        return GraphicalCodeDetector.decode_1(this.nativeObj, mat.nativeObj, mat2.nativeObj);
    }

    public String detectAndDecode(Mat mat, Mat mat2, Mat mat3) {
        return GraphicalCodeDetector.detectAndDecode_0(this.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public String detectAndDecode(Mat mat, Mat mat2) {
        return GraphicalCodeDetector.detectAndDecode_1(this.nativeObj, mat.nativeObj, mat2.nativeObj);
    }

    public String detectAndDecode(Mat mat) {
        return GraphicalCodeDetector.detectAndDecode_2(this.nativeObj, mat.nativeObj);
    }

    public boolean detectMulti(Mat mat, Mat mat2) {
        return GraphicalCodeDetector.detectMulti_0(this.nativeObj, mat.nativeObj, mat2.nativeObj);
    }

    public boolean decodeMulti(Mat mat, Mat mat2, List<String> list, List<Mat> list2) {
        Mat mat3 = new Mat();
        boolean bl = GraphicalCodeDetector.decodeMulti_0(this.nativeObj, mat.nativeObj, mat2.nativeObj, list, mat3.nativeObj);
        Converters.Mat_to_vector_Mat(mat3, list2);
        mat3.release();
        return bl;
    }

    public boolean decodeMulti(Mat mat, Mat mat2, List<String> list) {
        return GraphicalCodeDetector.decodeMulti_1(this.nativeObj, mat.nativeObj, mat2.nativeObj, list);
    }

    public boolean detectAndDecodeMulti(Mat mat, List<String> list, Mat mat2, List<Mat> list2) {
        Mat mat3 = new Mat();
        boolean bl = GraphicalCodeDetector.detectAndDecodeMulti_0(this.nativeObj, mat.nativeObj, list, mat2.nativeObj, mat3.nativeObj);
        Converters.Mat_to_vector_Mat(mat3, list2);
        mat3.release();
        return bl;
    }

    public boolean detectAndDecodeMulti(Mat mat, List<String> list, Mat mat2) {
        return GraphicalCodeDetector.detectAndDecodeMulti_1(this.nativeObj, mat.nativeObj, list, mat2.nativeObj);
    }

    public boolean detectAndDecodeMulti(Mat mat, List<String> list) {
        return GraphicalCodeDetector.detectAndDecodeMulti_2(this.nativeObj, mat.nativeObj, list);
    }

    public byte[] detectAndDecodeBytes(Mat mat, Mat mat2, Mat mat3) {
        return GraphicalCodeDetector.detectAndDecodeBytes_0(this.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public byte[] detectAndDecodeBytes(Mat mat, Mat mat2) {
        return GraphicalCodeDetector.detectAndDecodeBytes_1(this.nativeObj, mat.nativeObj, mat2.nativeObj);
    }

    public byte[] detectAndDecodeBytes(Mat mat) {
        return GraphicalCodeDetector.detectAndDecodeBytes_2(this.nativeObj, mat.nativeObj);
    }

    public byte[] decodeBytes(Mat mat, Mat mat2, Mat mat3) {
        return GraphicalCodeDetector.decodeBytes_0(this.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public byte[] decodeBytes(Mat mat, Mat mat2) {
        return GraphicalCodeDetector.decodeBytes_1(this.nativeObj, mat.nativeObj, mat2.nativeObj);
    }

    public boolean decodeBytesMulti(Mat mat, Mat mat2, List<byte[]> list, List<Mat> list2) {
        Mat mat3 = new Mat();
        boolean bl = GraphicalCodeDetector.decodeBytesMulti_0(this.nativeObj, mat.nativeObj, mat2.nativeObj, list, mat3.nativeObj);
        Converters.Mat_to_vector_Mat(mat3, list2);
        mat3.release();
        return bl;
    }

    public boolean decodeBytesMulti(Mat mat, Mat mat2, List<byte[]> list) {
        return GraphicalCodeDetector.decodeBytesMulti_1(this.nativeObj, mat.nativeObj, mat2.nativeObj, list);
    }

    public boolean detectAndDecodeBytesMulti(Mat mat, List<byte[]> list, Mat mat2, List<Mat> list2) {
        Mat mat3 = new Mat();
        boolean bl = GraphicalCodeDetector.detectAndDecodeBytesMulti_0(this.nativeObj, mat.nativeObj, list, mat2.nativeObj, mat3.nativeObj);
        Converters.Mat_to_vector_Mat(mat3, list2);
        mat3.release();
        return bl;
    }

    public boolean detectAndDecodeBytesMulti(Mat mat, List<byte[]> list, Mat mat2) {
        return GraphicalCodeDetector.detectAndDecodeBytesMulti_1(this.nativeObj, mat.nativeObj, list, mat2.nativeObj);
    }

    public boolean detectAndDecodeBytesMulti(Mat mat, List<byte[]> list) {
        return GraphicalCodeDetector.detectAndDecodeBytesMulti_2(this.nativeObj, mat.nativeObj, list);
    }

    protected void finalize() throws Throwable {
        GraphicalCodeDetector.delete(this.nativeObj);
    }

    private static native boolean detect_0(long var0, long var2, long var4);

    private static native String decode_0(long var0, long var2, long var4, long var6);

    private static native String decode_1(long var0, long var2, long var4);

    private static native String detectAndDecode_0(long var0, long var2, long var4, long var6);

    private static native String detectAndDecode_1(long var0, long var2, long var4);

    private static native String detectAndDecode_2(long var0, long var2);

    private static native boolean detectMulti_0(long var0, long var2, long var4);

    private static native boolean decodeMulti_0(long var0, long var2, long var4, List<String> var6, long var7);

    private static native boolean decodeMulti_1(long var0, long var2, long var4, List<String> var6);

    private static native boolean detectAndDecodeMulti_0(long var0, long var2, List<String> var4, long var5, long var7);

    private static native boolean detectAndDecodeMulti_1(long var0, long var2, List<String> var4, long var5);

    private static native boolean detectAndDecodeMulti_2(long var0, long var2, List<String> var4);

    private static native byte[] detectAndDecodeBytes_0(long var0, long var2, long var4, long var6);

    private static native byte[] detectAndDecodeBytes_1(long var0, long var2, long var4);

    private static native byte[] detectAndDecodeBytes_2(long var0, long var2);

    private static native byte[] decodeBytes_0(long var0, long var2, long var4, long var6);

    private static native byte[] decodeBytes_1(long var0, long var2, long var4);

    private static native boolean decodeBytesMulti_0(long var0, long var2, long var4, List<byte[]> var6, long var7);

    private static native boolean decodeBytesMulti_1(long var0, long var2, long var4, List<byte[]> var6);

    private static native boolean detectAndDecodeBytesMulti_0(long var0, long var2, List<byte[]> var4, long var5, long var7);

    private static native boolean detectAndDecodeBytesMulti_1(long var0, long var2, List<byte[]> var4, long var5);

    private static native boolean detectAndDecodeBytesMulti_2(long var0, long var2, List<byte[]> var4);

    private static native void delete(long var0);
}

